/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.wss4j2.callback;

import java.util.Objects;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.principal.WSUsernameTokenPrincipalImpl;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.cache.NullUserCache;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.support.SpringSecurityUtils;
import org.springframework.ws.soap.security.wss4j2.callback.AbstractWsPasswordCallbackHandler;
import org.springframework.ws.soap.security.wss4j2.callback.UsernameTokenPrincipalCallback;

public class SpringSecurityPasswordValidationCallbackHandler
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    private UserCache userCache = new NullUserCache();
    private @Nullable UserDetailsService userDetailsService;

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"userDetailsService is required");
    }

    @Override
    protected void handleUsernameToken(WSPasswordCallback callback) {
        UserDetails user = this.loadUserDetails(callback.getIdentifier());
        SpringSecurityUtils.checkUserValidity(user);
        callback.setPassword(user.getPassword());
    }

    @Override
    protected void handleUsernameTokenPrincipal(UsernameTokenPrincipalCallback callback) {
        UserDetails user = this.loadUserDetails(callback.getPrincipal().getName());
        WSUsernameTokenPrincipalImpl principal = callback.getPrincipal();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)principal, (Object)principal.getPassword(), user.getAuthorities());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + String.valueOf(authRequest)));
        }
        authRequest.setDetails((Object)user);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
    }

    @Override
    protected void handleCleanup(CleanupCallback callback) {
        SecurityContextHolder.clearContext();
    }

    private UserDetails loadUserDetails(String username) throws DataAccessException {
        UserDetails user = this.userCache.getUserFromCache(username);
        if (user == null) {
            user = Objects.requireNonNull(this.userDetailsService).loadUserByUsername(username);
            this.userCache.putUserInCache(user);
        }
        return user;
    }
}

