/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.support;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class KeyStoreFactoryBean
implements FactoryBean<KeyStore>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(KeyStoreFactoryBean.class);
    private KeyStore keyStore;
    private String type;
    private String provider;
    private Resource location;
    private char[] password;

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setPassword(String password) {
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setType(String type) {
        this.type = type;
    }

    public KeyStore getObject() {
        return this.keyStore;
    }

    public Class<KeyStore> getObjectType() {
        return KeyStore.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws GeneralSecurityException, IOException {
        this.keyStore = StringUtils.hasLength((String)this.provider) && StringUtils.hasLength((String)this.type) ? KeyStore.getInstance(this.type, this.provider) : (StringUtils.hasLength((String)this.type) ? KeyStore.getInstance(this.type) : KeyStore.getInstance(KeyStore.getDefaultType()));
        try (InputStream is = null;){
            if (this.location != null && this.location.exists()) {
                is = this.location.getInputStream();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Loading key store from " + String.valueOf(this.location)));
                }
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)"Creating empty key store");
            }
            this.keyStore.load(is, this.password);
        }
    }
}

