/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser;
import org.springframework.webflow.test.MockViewFactoryCreator;

public class TestFlowBuilderServicesFactory {
    private TestFlowBuilderServicesFactory() {
    }

    public static FlowBuilderServices getServices() {
        FlowBuilderServices services = new FlowBuilderServices(){

            public void setConversionService(ConversionService conversionService) {
                super.setConversionService(conversionService);
                this.setExpressionParser((ExpressionParser)new WebFlowSpringELExpressionParser(new SpelExpressionParser(), conversionService));
            }
        };
        services.setViewFactoryCreator(new MockViewFactoryCreator());
        services.setConversionService((ConversionService)new DefaultConversionService());
        services.setApplicationContext((ApplicationContext)TestFlowBuilderServicesFactory.createTestApplicationContext());
        return services;
    }

    private static StaticApplicationContext createTestApplicationContext() {
        StaticApplicationContext context = new StaticApplicationContext();
        context.refresh();
        return context;
    }
}

