/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ExpressionVariable;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.ParserException;
import org.springframework.binding.expression.el.BindingValueExpression;
import org.springframework.binding.expression.el.DefaultElContextFactory;
import org.springframework.binding.expression.el.ELContextFactory;
import org.springframework.binding.expression.el.ELExpression;
import org.springframework.binding.expression.support.NullParserContext;
import org.springframework.util.Assert;

public class ELExpressionParser
implements ExpressionParser {
    private ExpressionFactory expressionFactory;
    private Map contextFactories = new HashMap();
    private ConversionService conversionService = new DefaultConversionService();

    public ELExpressionParser(ExpressionFactory expressionFactory) {
        this.init(expressionFactory);
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"The conversion service is required");
        this.conversionService = conversionService;
    }

    public void putContextFactory(Class contextType, ELContextFactory contextFactory) {
        Assert.notNull((Object)contextFactory, (String)"The EL context factory cannot be null");
        this.contextFactories.put(contextType, contextFactory);
    }

    public Expression parseExpression(String expressionString, ParserContext context) throws ParserException {
        Assert.notNull((Object)expressionString, (String)"The expression string to parse is required");
        if (context == null) {
            context = NullParserContext.INSTANCE;
        }
        if (context.isTemplate()) {
            return this.parseExpressionInternal(expressionString, context, true);
        }
        this.assertNotDelimited(expressionString);
        this.assertHasText(expressionString);
        return this.parseExpressionInternal("#{" + expressionString + "}", context, false);
    }

    private Expression parseExpressionInternal(String expressionString, ParserContext context, boolean template) throws ParserException {
        Assert.notNull((Object)expressionString, (String)"The expression string to parse is required");
        try {
            ValueExpression expression = this.parseValueExpression(expressionString, context);
            ELContextFactory contextFactory = this.getContextFactory(context.getEvaluationContextType(), expressionString);
            return new ELExpression(contextFactory, expression);
        }
        catch (ELException e) {
            throw new ParserException(expressionString, e);
        }
    }

    private ValueExpression parseValueExpression(String expressionString, ParserContext context) throws ELException {
        ParserELContext elContext = new ParserELContext();
        elContext.mapVariables(context.getExpressionVariables(), this.expressionFactory);
        ValueExpression expression = this.expressionFactory.createValueExpression((ELContext)elContext, expressionString, Object.class);
        return new BindingValueExpression(expression, this.getExpectedType(context), this.conversionService, context.isTemplate());
    }

    private Class getExpectedType(ParserContext context) {
        Class<Object> expectedType = context.getExpectedEvaluationResultType();
        return expectedType != null ? expectedType : Object.class;
    }

    private ELContextFactory getContextFactory(Class expressionTargetType, String expressionString) {
        if (this.contextFactories.containsKey(expressionTargetType)) {
            return (ELContextFactory)this.contextFactories.get(expressionTargetType);
        }
        return (ELContextFactory)this.contextFactories.get(Object.class);
    }

    private void init(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
        DefaultElContextFactory contextFactory = new DefaultElContextFactory();
        this.putContextFactory(null, contextFactory);
        this.putContextFactory(Object.class, contextFactory);
    }

    private void assertNotDelimited(String expressionString) {
        if (expressionString.startsWith("#{") && expressionString.endsWith("}") || expressionString.startsWith("${") && expressionString.endsWith("}")) {
            throw new ParserException(expressionString, "This expression '" + expressionString + "' being parsed is expected be an 'eval' EL expression string. " + "Do not attempt to enclose such expression strings in #{} or ${} delimiters. " + "If you need to parse a template that mixes literal text with evaluatable blocks, " + "set the 'template' parser context attribute to true.", null);
        }
    }

    private void assertHasText(String expressionString) {
        if (expressionString.length() == 0) {
            throw new ParserException(expressionString, "The EL eval expression to parse must have text", null);
        }
    }

    private static class VariableMapperImpl
    extends VariableMapper {
        private Map variables = new HashMap();

        private VariableMapperImpl() {
        }

        public ValueExpression resolveVariable(String name) {
            return (ValueExpression)this.variables.get(name);
        }

        public ValueExpression setVariable(String name, ValueExpression value) {
            return this.variables.put(name, value);
        }

        public String toString() {
            return this.variables.toString();
        }
    }

    private class ParserELContext
    extends ELContext {
        private VariableMapper variableMapper;

        private ParserELContext() {
        }

        public ELResolver getELResolver() {
            return null;
        }

        public FunctionMapper getFunctionMapper() {
            return null;
        }

        public VariableMapper getVariableMapper() {
            return this.variableMapper;
        }

        public void mapVariables(ExpressionVariable[] variables, ExpressionFactory expressionFactory) {
            if (variables != null && variables.length > 0) {
                this.variableMapper = new VariableMapperImpl();
                for (int i = 0; i < variables.length; ++i) {
                    ValueExpression expr;
                    ParserContext context;
                    ExpressionVariable var = variables[i];
                    ParserContext parserContext = context = var.getParserContext() != null ? var.getParserContext() : NullParserContext.INSTANCE;
                    if (context.isTemplate()) {
                        expr = ELExpressionParser.this.parseValueExpression(var.getValueExpression(), context);
                    } else {
                        ELExpressionParser.this.assertNotDelimited(var.getValueExpression());
                        ELExpressionParser.this.assertHasText(var.getValueExpression());
                        expr = ELExpressionParser.this.parseValueExpression("#{" + var.getValueExpression() + "}", context);
                    }
                    this.variableMapper.setVariable(var.getName(), expr);
                }
            }
        }
    }
}

