/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.filter;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTypeFilter
extends AbstractTypeHierarchyTraversingFilter {
    private final Class<? extends Annotation> annotationType;

    public AnnotationTypeFilter(Class<? extends Annotation> annotationType) {
        super(annotationType.isAnnotationPresent(Inherited.class), false);
        this.annotationType = annotationType;
    }

    @Override
    protected boolean matchSelf(MetadataReader metadataReader) {
        return metadataReader.getAnnotationMetadata().hasAnnotation(this.annotationType.getName());
    }

    @Override
    protected Boolean matchSuperClass(String superClassName) {
        if (Object.class.getName().equals(superClassName)) {
            return Boolean.FALSE;
        }
        if (superClassName.startsWith("java.")) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(superClassName);
                return clazz.getAnnotation(this.annotationType) != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

