/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.weaving;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.weaving.AspectJWeavingEnabler;
import org.springframework.context.weaving.DefaultContextLoadTimeWeaver;
import org.w3c.dom.Element;

public class LoadTimeWeaverBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String WEAVER_CLASS_ATTRIBUTE = "weaver-class";
    private static final String ASPECTJ_WEAVING_ATTRIBUTE = "aspectj-weaving";
    private static final String ASPECTJ_AOP_XML_RESOURCE = "META-INF/aop.xml";

    protected String getBeanClassName(Element element) {
        if (element.hasAttribute(WEAVER_CLASS_ATTRIBUTE)) {
            return element.getAttribute(WEAVER_CLASS_ATTRIBUTE);
        }
        return DefaultContextLoadTimeWeaver.class.getName();
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return "loadTimeWeaver";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setRole(2);
        if (this.isAspectJWeavingEnabled(element.getAttribute(ASPECTJ_WEAVING_ATTRIBUTE), parserContext)) {
            parserContext.getReaderContext().registerWithGeneratedName(new RootBeanDefinition(AspectJWeavingEnabler.class));
        }
    }

    protected boolean isAspectJWeavingEnabled(String value, ParserContext parserContext) {
        if ("on".equals(value)) {
            return true;
        }
        if ("off".equals(value)) {
            return false;
        }
        ClassLoader cl = parserContext.getReaderContext().getResourceLoader().getClassLoader();
        return cl.getResource(ASPECTJ_AOP_XML_RESOURCE) != null;
    }
}

