/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.OverridingClassLoader;

class ContextTypeMatchClassLoader
extends OverridingClassLoader {
    private final Map bytesCache = new HashMap();

    public ContextTypeMatchClassLoader(ClassLoader parent) {
        super(parent);
        this.excludePackage("org.springframework");
    }

    protected Class loadClassForOverriding(String name) throws ClassNotFoundException {
        byte[] bytes = (byte[])this.bytesCache.get(name);
        if (bytes == null) {
            bytes = this.loadBytesForClass(name);
            if (bytes != null) {
                this.bytesCache.put(name, bytes);
            } else {
                return null;
            }
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }
}

