/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.beans.Introspector;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AnnotationBeanNameGenerator
implements BeanNameGenerator {
    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String beanName;
        if (definition instanceof AnnotatedBeanDefinition && StringUtils.hasText(beanName = this.determineBeanNameFromAnnotation((AnnotatedBeanDefinition)definition))) {
            return beanName;
        }
        return this.buildDefaultBeanName(definition);
    }

    protected String determineBeanNameFromAnnotation(AnnotatedBeanDefinition annotatedDef) {
        Set<String> types = annotatedDef.getMetadata().getAnnotationTypes();
        String beanName = null;
        for (String type : types) {
            String value;
            Map<String, Object> attributes;
            if (!this.isStereotypeWithNameValue(type) || (attributes = annotatedDef.getMetadata().getAnnotationAttributes(type)) == null || !StringUtils.hasLength(value = (String)attributes.get("value"))) continue;
            if (beanName != null && !value.equals(beanName)) {
                throw new IllegalStateException("Stereotype annotations suggest inconsistent component names: '" + beanName + "' versus '" + value + "'");
            }
            beanName = value;
        }
        return beanName;
    }

    protected boolean isStereotypeWithNameValue(String annotationType) {
        return annotationType.startsWith("org.springframework.stereotype.");
    }

    protected String buildDefaultBeanName(BeanDefinition definition) {
        String shortClassName = ClassUtils.getShortName(definition.getBeanClassName());
        return Introspector.decapitalize(shortClassName);
    }
}

