/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.Tag;
import org.jspecify.annotations.Nullable;
import org.springframework.web.servlet.tags.ArgumentAware;

public class ArgumentTag
extends BodyTagSupport {
    private @Nullable Object value;
    private boolean valueSet;

    public void setValue(Object value) {
        this.value = value;
        this.valueSet = true;
    }

    public int doEndTag() throws JspException {
        Object argument = null;
        if (this.valueSet) {
            argument = this.value;
        } else if (this.getBodyContent() != null) {
            argument = this.getBodyContent().getString().trim();
        }
        ArgumentAware argumentAwareTag = (ArgumentAware)ArgumentTag.findAncestorWithClass((Tag)this, ArgumentAware.class);
        if (argumentAwareTag == null) {
            throw new JspException("The argument tag must be a descendant of a tag that supports arguments");
        }
        argumentAwareTag.addArgument(argument);
        return 6;
    }

    public void release() {
        super.release();
        this.value = null;
        this.valueSet = false;
    }
}

