/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

public class InterceptorRegistration {
    private final HandlerInterceptor interceptor;
    private @Nullable List<String> includePatterns;
    private @Nullable List<String> excludePatterns;
    private @Nullable List<HttpMethod> includeHttpMethods;
    private @Nullable List<HttpMethod> excludeHttpMethods;
    private @Nullable PathMatcher pathMatcher;
    private int order = 0;

    public InterceptorRegistration(HandlerInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"Interceptor is required");
        this.interceptor = interceptor;
    }

    public InterceptorRegistration addPathPatterns(String ... patterns) {
        return this.addPathPatterns(Arrays.asList(patterns));
    }

    public InterceptorRegistration addPathPatterns(List<String> patterns) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<String>(patterns.size());
        }
        this.includePatterns.addAll(patterns);
        return this;
    }

    public InterceptorRegistration excludePathPatterns(String ... patterns) {
        return this.excludePathPatterns(Arrays.asList(patterns));
    }

    public InterceptorRegistration excludePathPatterns(List<String> patterns) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<String>(patterns.size());
        }
        this.excludePatterns.addAll(patterns);
        return this;
    }

    public InterceptorRegistration includeHttpMethods(HttpMethod ... httpMethods) {
        return this.includeHttpMethods(Arrays.asList(httpMethods));
    }

    public InterceptorRegistration includeHttpMethods(List<HttpMethod> httpMethods) {
        if (this.includeHttpMethods == null) {
            this.includeHttpMethods = new ArrayList<HttpMethod>(httpMethods.size());
        }
        this.includeHttpMethods.addAll(httpMethods);
        return this;
    }

    public InterceptorRegistration excludeHttpMethods(HttpMethod ... httpMethods) {
        return this.excludeHttpMethods(Arrays.asList(httpMethods));
    }

    public InterceptorRegistration excludeHttpMethods(List<HttpMethod> httpMethods) {
        if (this.excludeHttpMethods == null) {
            this.excludeHttpMethods = new ArrayList<HttpMethod>(httpMethods.size());
        }
        this.excludeHttpMethods.addAll(httpMethods);
        return this;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public InterceptorRegistration pathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
        return this;
    }

    public InterceptorRegistration order(int order) {
        this.order = order;
        return this;
    }

    protected int getOrder() {
        return this.order;
    }

    protected Object getInterceptor() {
        if (this.includePatterns == null && this.excludePatterns == null && this.includeHttpMethods == null && this.excludeHttpMethods == null) {
            return this.interceptor;
        }
        MappedInterceptor mappedInterceptor = new MappedInterceptor(StringUtils.toStringArray(this.includePatterns), StringUtils.toStringArray(this.excludePatterns), this.includeHttpMethods != null ? this.includeHttpMethods.toArray(new HttpMethod[0]) : null, this.excludeHttpMethods != null ? this.excludeHttpMethods.toArray(new HttpMethod[0]) : null, this.interceptor, null);
        if (this.pathMatcher != null) {
            mappedInterceptor.setPathMatcher(this.pathMatcher);
        }
        return mappedInterceptor;
    }
}

