/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import jakarta.servlet.jsp.JspException;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class LabelTag
extends AbstractHtmlElementTag {
    private static final String LABEL_TAG = "label";
    private static final String FOR_ATTRIBUTE = "for";
    private @Nullable TagWriter tagWriter;
    private @Nullable String forId;

    public void setFor(String forId) {
        this.forId = forId;
    }

    protected @Nullable String getFor() {
        return this.forId;
    }

    @Override
    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag(LABEL_TAG);
        tagWriter.writeAttribute(FOR_ATTRIBUTE, this.resolveFor());
        this.writeDefaultAttributes(tagWriter);
        tagWriter.forceBlock();
        this.tagWriter = tagWriter;
        return 1;
    }

    @Override
    protected @Nullable String getName() throws JspException {
        return null;
    }

    protected String resolveFor() throws JspException {
        if (StringUtils.hasText((String)this.forId)) {
            return this.getDisplayString(this.evaluate(FOR_ATTRIBUTE, this.forId));
        }
        return this.autogenerateFor();
    }

    protected String autogenerateFor() throws JspException {
        return StringUtils.deleteAny((String)this.getPropertyPath(), (String)"[]");
    }

    public int doEndTag() throws JspException {
        Assert.state((this.tagWriter != null ? 1 : 0) != 0, (String)"No TagWriter set");
        this.tagWriter.endTag();
        return 6;
    }

    @Override
    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
    }
}

