/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindException;
import org.springframework.validation.method.MethodValidationException;
import org.springframework.web.ErrorResponse;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.context.request.async.AsyncRequestNotUsableException;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;
import org.springframework.web.method.annotation.HandlerMethodValidationException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public class DefaultHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");

    public DefaultHandlerExceptionResolver() {
        this.setOrder(Integer.MAX_VALUE);
        this.setWarnLogCategory(this.getClass().getName());
    }

    @Override
    @Nullable
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, @Nullable Object handler, Exception ex) {
        block33: {
            try {
                if (ex instanceof ErrorResponse) {
                    ErrorResponse errorResponse = (ErrorResponse)ex;
                    ModelAndView mav = null;
                    if (ex instanceof HttpRequestMethodNotSupportedException) {
                        HttpRequestMethodNotSupportedException theEx = (HttpRequestMethodNotSupportedException)ex;
                        mav = this.handleHttpRequestMethodNotSupported(theEx, request, response, handler);
                    } else if (ex instanceof HttpMediaTypeNotSupportedException) {
                        HttpMediaTypeNotSupportedException theEx = (HttpMediaTypeNotSupportedException)ex;
                        mav = this.handleHttpMediaTypeNotSupported(theEx, request, response, handler);
                    } else if (ex instanceof HttpMediaTypeNotAcceptableException) {
                        HttpMediaTypeNotAcceptableException theEx = (HttpMediaTypeNotAcceptableException)ex;
                        mav = this.handleHttpMediaTypeNotAcceptable(theEx, request, response, handler);
                    } else if (ex instanceof MissingPathVariableException) {
                        MissingPathVariableException theEx = (MissingPathVariableException)ex;
                        mav = this.handleMissingPathVariable(theEx, request, response, handler);
                    } else if (ex instanceof MissingServletRequestParameterException) {
                        MissingServletRequestParameterException theEx = (MissingServletRequestParameterException)ex;
                        mav = this.handleMissingServletRequestParameter(theEx, request, response, handler);
                    } else if (ex instanceof MissingServletRequestPartException) {
                        MissingServletRequestPartException theEx = (MissingServletRequestPartException)ex;
                        mav = this.handleMissingServletRequestPartException(theEx, request, response, handler);
                    } else if (ex instanceof ServletRequestBindingException) {
                        ServletRequestBindingException theEx = (ServletRequestBindingException)ex;
                        mav = this.handleServletRequestBindingException(theEx, request, response, handler);
                    } else if (ex instanceof MethodArgumentNotValidException) {
                        MethodArgumentNotValidException theEx = (MethodArgumentNotValidException)ex;
                        mav = this.handleMethodArgumentNotValidException(theEx, request, response, handler);
                    } else if (ex instanceof HandlerMethodValidationException) {
                        HandlerMethodValidationException theEx = (HandlerMethodValidationException)ex;
                        mav = this.handleHandlerMethodValidationException(theEx, request, response, handler);
                    } else if (ex instanceof NoHandlerFoundException) {
                        NoHandlerFoundException theEx = (NoHandlerFoundException)((Object)ex);
                        mav = this.handleNoHandlerFoundException(theEx, request, response, handler);
                    } else if (ex instanceof NoResourceFoundException) {
                        NoResourceFoundException theEx = (NoResourceFoundException)((Object)ex);
                        mav = this.handleNoResourceFoundException(theEx, request, response, handler);
                    } else if (ex instanceof AsyncRequestTimeoutException) {
                        AsyncRequestTimeoutException theEx = (AsyncRequestTimeoutException)ex;
                        mav = this.handleAsyncRequestTimeoutException(theEx, request, response, handler);
                    }
                    return mav != null ? mav : this.handleErrorResponse(errorResponse, request, response, handler);
                }
                if (ex instanceof ConversionNotSupportedException) {
                    ConversionNotSupportedException theEx = (ConversionNotSupportedException)ex;
                    return this.handleConversionNotSupported(theEx, request, response, handler);
                }
                if (ex instanceof TypeMismatchException) {
                    TypeMismatchException theEx = (TypeMismatchException)ex;
                    return this.handleTypeMismatch(theEx, request, response, handler);
                }
                if (ex instanceof HttpMessageNotReadableException) {
                    HttpMessageNotReadableException theEx = (HttpMessageNotReadableException)ex;
                    return this.handleHttpMessageNotReadable(theEx, request, response, handler);
                }
                if (ex instanceof HttpMessageNotWritableException) {
                    HttpMessageNotWritableException theEx = (HttpMessageNotWritableException)ex;
                    return this.handleHttpMessageNotWritable(theEx, request, response, handler);
                }
                if (ex instanceof MethodValidationException) {
                    MethodValidationException theEx = (MethodValidationException)ex;
                    return this.handleMethodValidationException(theEx, request, response, handler);
                }
                if (ex instanceof BindException) {
                    BindException theEx = (BindException)ex;
                    return this.handleBindException(theEx, request, response, handler);
                }
                if (ex instanceof AsyncRequestNotUsableException) {
                    return this.handleAsyncRequestNotUsableException((AsyncRequestNotUsableException)ex, request, response, handler);
                }
            }
            catch (Exception handlerEx) {
                if (!this.logger.isWarnEnabled()) break block33;
                this.logger.warn((Object)("Failure while trying to resolve exception [" + ex.getClass().getName() + "]"), (Throwable)handlerEx);
            }
        }
        return null;
    }

    @Nullable
    protected ModelAndView handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleHttpMediaTypeNotSupported(HttpMediaTypeNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleHttpMediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMissingPathVariable(MissingPathVariableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMissingServletRequestParameter(MissingServletRequestParameterException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMissingServletRequestPartException(MissingServletRequestPartException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleServletRequestBindingException(ServletRequestBindingException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleMethodArgumentNotValidException(MethodArgumentNotValidException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleHandlerMethodValidationException(HandlerMethodValidationException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleNoHandlerFoundException(NoHandlerFoundException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        return null;
    }

    @Nullable
    protected ModelAndView handleNoResourceFoundException(NoResourceFoundException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    @Nullable
    protected ModelAndView handleAsyncRequestTimeoutException(AsyncRequestTimeoutException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        return null;
    }

    protected ModelAndView handleAsyncRequestNotUsableException(AsyncRequestNotUsableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) {
        return new ModelAndView();
    }

    protected ModelAndView handleErrorResponse(ErrorResponse errorResponse, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        if (!response.isCommitted()) {
            HttpHeaders headers = errorResponse.getHeaders();
            headers.forEach((name, values) -> values.forEach(value -> response.addHeader(name, value)));
            int status = errorResponse.getStatusCode().value();
            String message = errorResponse.getBody().getDetail();
            if (message != null) {
                response.sendError(status, message);
            } else {
                response.sendError(status);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Ignoring exception, response committed already: " + errorResponse));
        }
        return new ModelAndView();
    }

    protected ModelAndView handleConversionNotSupported(ConversionNotSupportedException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        this.sendServerError((Exception)ex, request, response);
        return new ModelAndView();
    }

    protected ModelAndView handleTypeMismatch(TypeMismatchException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        response.sendError(400);
        return new ModelAndView();
    }

    protected ModelAndView handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        if (!response.isCommitted()) {
            response.sendError(400);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Ignoring exception, response committed already: " + ex));
        }
        return new ModelAndView();
    }

    protected ModelAndView handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        if (!response.isCommitted()) {
            this.sendServerError((Exception)ex, request, response);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Ignoring exception, response committed already: " + ex));
        }
        return new ModelAndView();
    }

    protected ModelAndView handleMethodValidationException(MethodValidationException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        this.sendServerError((Exception)ex, request, response);
        return new ModelAndView();
    }

    @Deprecated(since="6.0", forRemoval=true)
    protected ModelAndView handleBindException(BindException ex, HttpServletRequest request, HttpServletResponse response, @Nullable Object handler) throws IOException {
        response.sendError(400);
        return new ModelAndView();
    }

    protected void sendServerError(Exception ex, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("jakarta.servlet.error.exception", (Object)ex);
        response.sendError(500);
    }

    @Override
    protected void logException(Exception ex, HttpServletRequest request) {
        if (ex instanceof NoHandlerFoundException || ex instanceof NoResourceFoundException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)this.buildLogMessage(ex, request));
            }
            return;
        }
        super.logException(ex, request);
    }
}

