/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public class FormTag
extends AbstractFormTag {
    public static final String COMMAND_NAME_VARIABLE_NAME = "org.springframework.web.servlet.tags.form.FormTag.commandName";
    private static final String DEFAULT_METHOD = "POST";
    public static final String DEFAULT_COMMAND_NAME = "command";
    public static final String COMMAND_NAME_ATTRIBUTE = "commandName";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ONSUBMIT_ATTRIBUTE = "onsubmit";
    public static final String ONRESET_ATTRIBUTE = "onreset";
    public static final String METHOD_ATTRIBUTE = "method";
    public static final String ACTION_ATTRIBUTE = "action";
    public static final String ENCTYPE_ATTRIBUTE = "enctype";
    private TagWriter tagWriter;
    private String commandName = "command";
    private String name;
    private String action;
    private String method = "POST";
    private String enctype;
    private String onsubmit;
    private String onreset;

    public void setCommandName(String commandName) {
        Assert.notNull((Object)commandName, (String)"'commandName' cannot be null");
        this.commandName = commandName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAction(String action) {
        this.action = action != null ? action : "";
    }

    public void setMethod(String method) {
        Assert.hasText((String)method, (String)"'method' cannot be null or zero length");
        this.method = method;
    }

    public void setEnctype(String enctype) {
        Assert.hasText((String)enctype, (String)"'enctype' cannot be null or zero length.");
        this.enctype = enctype;
    }

    public void setOnsubmit(String onsubmit) {
        Assert.hasText((String)onsubmit, (String)"'onsubmit' cannot be null or zero length.");
        this.onsubmit = onsubmit;
    }

    public void setOnreset(String onreset) {
        Assert.hasText((String)onreset, (String)"'onreset' cannot be null or zero length.");
        this.onreset = onreset;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        this.tagWriter = tagWriter;
        this.tagWriter.startTag("form");
        this.tagWriter.writeAttribute(METHOD_ATTRIBUTE, ObjectUtils.nullSafeToString((Object)this.evaluate(METHOD_ATTRIBUTE, this.method)));
        this.writeOptionalAttribute(tagWriter, NAME_ATTRIBUTE, this.name);
        this.writeOptionalAttribute(tagWriter, ACTION_ATTRIBUTE, this.action);
        this.writeOptionalAttribute(tagWriter, ENCTYPE_ATTRIBUTE, this.enctype);
        this.writeOptionalAttribute(tagWriter, ONSUBMIT_ATTRIBUTE, this.onsubmit);
        this.writeOptionalAttribute(tagWriter, ONRESET_ATTRIBUTE, this.onreset);
        this.tagWriter.forceBlock();
        this.pageContext.setAttribute(COMMAND_NAME_VARIABLE_NAME, (Object)this.resolveCommandName());
        return 1;
    }

    private String resolveCommandName() throws JspException {
        Object resolvedCommmandName = this.evaluate(COMMAND_NAME_ATTRIBUTE, this.commandName);
        if (resolvedCommmandName == null) {
            throw new IllegalArgumentException("'commandName' cannot be null.");
        }
        return (String)resolvedCommmandName;
    }

    public int doEndTag() throws JspException {
        this.tagWriter.endTag();
        this.pageContext.removeAttribute(COMMAND_NAME_VARIABLE_NAME);
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.tagWriter = null;
    }
}

