/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class ControllerClassNameHandlerMapping
extends AbstractUrlHandlerMapping
implements HandlerMapping {
    private static final String CONTROLLER_SUFFIX = "Controller";
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$Controller;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$multiaction$MultiActionController;

    protected void initApplicationContext() {
        this.detectHandlers();
    }

    private void detectHandlers() {
        String[] beanNames = this.getApplicationContext().getBeanNamesForType(class$org$springframework$web$servlet$mvc$Controller == null ? (class$org$springframework$web$servlet$mvc$Controller = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.Controller")) : class$org$springframework$web$servlet$mvc$Controller);
        for (int i = 0; i < beanNames.length; ++i) {
            String controllerBeanName = beanNames[i];
            Class controllerClass = this.getApplicationContext().getType(controllerBeanName);
            String urlPath = this.generatePathMapping(controllerClass);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registering Controller '" + controllerBeanName + "' as handler for URL path [" + urlPath + "]"));
            }
            this.registerHandler(urlPath, controllerBeanName);
        }
    }

    protected String generatePathMapping(Class controllerClass) {
        StringBuffer pathMapping = new StringBuffer("/");
        String className = ClassUtils.getShortName((String)controllerClass.getName());
        String path = className.endsWith(CONTROLLER_SUFFIX) ? className.substring(0, className.indexOf(CONTROLLER_SUFFIX)) : className;
        pathMapping.append(path.toLowerCase());
        if ((class$org$springframework$web$servlet$mvc$multiaction$MultiActionController == null ? (class$org$springframework$web$servlet$mvc$multiaction$MultiActionController = ControllerClassNameHandlerMapping.class$("org.springframework.web.servlet.mvc.multiaction.MultiActionController")) : class$org$springframework$web$servlet$mvc$multiaction$MultiActionController).isAssignableFrom(controllerClass)) {
            pathMapping.append("/*");
        }
        return pathMapping.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

