/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.DefaultFragmentsRenderingBuilder;
import org.springframework.web.reactive.result.view.Fragment;
import reactor.core.publisher.Flux;

public interface FragmentsRendering {
    public @Nullable HttpStatusCode status();

    public HttpHeaders headers();

    public Flux<Fragment> fragments();

    public static Builder fragment(String viewName) {
        return new DefaultFragmentsRenderingBuilder().fragment(viewName);
    }

    public static Builder fragment(String viewName, Map<String, Object> model) {
        return new DefaultFragmentsRenderingBuilder().fragment(viewName, model);
    }

    public static Builder fragments(Collection<Fragment> fragments) {
        return new DefaultFragmentsRenderingBuilder().fragments(fragments);
    }

    public static <P extends Publisher<Fragment>> Builder fragmentsPublisher(P fragmentsPublisher) {
        return new DefaultFragmentsRenderingBuilder(fragmentsPublisher);
    }

    public static Builder fragmentsProducer(Object fragmentsProducer) {
        ReactiveAdapter adapter = ReactiveAdapterRegistry.getSharedInstance().getAdapter(fragmentsProducer.getClass());
        Assert.isTrue((adapter != null ? 1 : 0) != 0, (String)("Unknown producer " + String.valueOf(fragmentsProducer.getClass())));
        Publisher publisher = adapter.toPublisher(fragmentsProducer);
        return FragmentsRendering.fragmentsPublisher(publisher);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static Builder with(String viewName, Map<String, Object> model) {
        return FragmentsRendering.fragment(viewName, model);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static Builder with(String viewName) {
        return FragmentsRendering.fragment(viewName);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static Builder withCollection(Collection<Fragment> fragments) {
        return FragmentsRendering.fragments(fragments);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static <P extends Publisher<Fragment>> Builder withPublisher(P fragmentsPublisher) {
        return FragmentsRendering.fragmentsPublisher(fragmentsPublisher);
    }

    @Deprecated(since="6.2.13", forRemoval=true)
    public static Builder withProducer(Object fragmentsProducer) {
        return FragmentsRendering.fragmentsProducer(fragmentsProducer);
    }

    public static interface Builder {
        public Builder status(HttpStatusCode var1);

        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder fragment(String var1, Map<String, Object> var2);

        public Builder fragment(String var1);

        public Builder fragment(Fragment var1);

        public Builder fragments(Collection<Fragment> var1);

        public FragmentsRendering build();
    }
}

