/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.StandardWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.TomcatWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.upgrade.DefaultServerEndpointConfig;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class StandardWebSocketUpgradeStrategy
implements RequestUpgradeStrategy {
    private static final String SERVER_CONTAINER_ATTR = "jakarta.websocket.server.ServerContainer";
    private @Nullable Long asyncSendTimeout;
    private @Nullable Long maxSessionIdleTimeout;
    private @Nullable Integer maxTextMessageBufferSize;
    private @Nullable Integer maxBinaryMessageBufferSize;
    private @Nullable ServerContainer serverContainer;

    public void setAsyncSendTimeout(Long timeoutInMillis) {
        this.asyncSendTimeout = timeoutInMillis;
    }

    public @Nullable Long getAsyncSendTimeout() {
        return this.asyncSendTimeout;
    }

    public void setMaxSessionIdleTimeout(Long timeoutInMillis) {
        this.maxSessionIdleTimeout = timeoutInMillis;
    }

    public @Nullable Long getMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setMaxTextMessageBufferSize(Integer bufferSize) {
        this.maxTextMessageBufferSize = bufferSize;
    }

    public @Nullable Integer getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setMaxBinaryMessageBufferSize(Integer bufferSize) {
        this.maxBinaryMessageBufferSize = bufferSize;
    }

    public @Nullable Integer getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        HttpServletRequest servletRequest = (HttpServletRequest)ServerHttpRequestDecorator.getNativeRequest((ServerHttpRequest)request);
        HttpServletResponse servletResponse = (HttpServletResponse)ServerHttpResponseDecorator.getNativeResponse((ServerHttpResponse)response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory bufferFactory = response.bufferFactory();
        return exchange2.getResponse().setComplete().then(Mono.deferContextual(contextView -> {
            StandardWebSocketHandlerAdapter endpoint = new StandardWebSocketHandlerAdapter(ContextWebSocketHandler.decorate(handler, contextView), session -> new TomcatWebSocketSession((Session)session, handshakeInfo, bufferFactory));
            String requestURI = servletRequest.getRequestURI();
            DefaultServerEndpointConfig config = new DefaultServerEndpointConfig(requestURI, endpoint);
            config.setSubprotocols(subProtocol != null ? Collections.singletonList(subProtocol) : Collections.emptyList());
            try {
                this.upgradeHttpToWebSocket(servletRequest, servletResponse, config, Collections.emptyMap());
            }
            catch (Exception ex) {
                return Mono.error((Throwable)ex);
            }
            return Mono.empty();
        }));
    }

    protected void upgradeHttpToWebSocket(HttpServletRequest request, HttpServletResponse response, ServerEndpointConfig endpointConfig, Map<String, String> pathParams) throws Exception {
        this.getContainer(request).upgradeHttpToWebSocket((Object)request, (Object)response, endpointConfig, pathParams);
    }

    protected ServerContainer getContainer(HttpServletRequest request) {
        if (this.serverContainer == null) {
            Object container = request.getServletContext().getAttribute(SERVER_CONTAINER_ATTR);
            Assert.state((boolean)(container instanceof ServerContainer), (String)"ServletContext attribute 'jakarta.websocket.server.ServerContainer' not found.");
            this.serverContainer = (ServerContainer)container;
            this.initServerContainer(this.serverContainer);
        }
        return this.serverContainer;
    }

    private void initServerContainer(ServerContainer serverContainer) {
        if (this.asyncSendTimeout != null) {
            serverContainer.setAsyncSendTimeout(this.asyncSendTimeout.longValue());
        }
        if (this.maxSessionIdleTimeout != null) {
            serverContainer.setDefaultMaxSessionIdleTimeout(this.maxSessionIdleTimeout.longValue());
        }
        if (this.maxTextMessageBufferSize != null) {
            serverContainer.setDefaultMaxTextMessageBufferSize(this.maxTextMessageBufferSize.intValue());
        }
        if (this.maxBinaryMessageBufferSize != null) {
            serverContainer.setDefaultMaxBinaryMessageBufferSize(this.maxBinaryMessageBufferSize.intValue());
        }
    }
}

