/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;

public class UnsupportedMediaTypeException
extends NestedRuntimeException {
    private final @Nullable MediaType contentType;
    private final List<MediaType> supportedMediaTypes;
    private final @Nullable ResolvableType bodyType;

    public UnsupportedMediaTypeException(String reason) {
        super(reason);
        this.contentType = null;
        this.supportedMediaTypes = Collections.emptyList();
        this.bodyType = null;
    }

    public UnsupportedMediaTypeException(@Nullable MediaType contentType, List<MediaType> supportedTypes) {
        this(contentType, supportedTypes, null);
    }

    public UnsupportedMediaTypeException(@Nullable MediaType contentType, List<MediaType> supportedTypes, @Nullable ResolvableType bodyType) {
        super(UnsupportedMediaTypeException.initReason(contentType, bodyType));
        this.contentType = contentType;
        this.supportedMediaTypes = Collections.unmodifiableList(supportedTypes);
        this.bodyType = bodyType;
    }

    private static String initReason(@Nullable MediaType contentType, @Nullable ResolvableType bodyType) {
        return "Content type '" + String.valueOf(contentType != null ? contentType : "") + "' not supported" + (String)(bodyType != null ? " for bodyType=" + bodyType.toString() : "");
    }

    public @Nullable MediaType getContentType() {
        return this.contentType;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public @Nullable ResolvableType getBodyType() {
        return this.bodyType;
    }
}

