/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import org.jspecify.annotations.Nullable;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.MissingApiVersionException;
import org.springframework.web.server.ServerWebExchange;

public interface ApiVersionStrategy {
    public @Nullable String resolveVersion(ServerWebExchange var1);

    public Comparable<?> parseVersion(String var1);

    public void validateVersion(@Nullable Comparable<?> var1, ServerWebExchange var2) throws MissingApiVersionException, InvalidApiVersionException;

    public @Nullable Comparable<?> getDefaultVersion();

    default public @Nullable Comparable<?> resolveParseAndValidateVersion(ServerWebExchange exchange2) {
        String value = this.resolveVersion(exchange2);
        if (value == null) {
            return this.getDefaultVersion();
        }
        try {
            Comparable<?> version = this.parseVersion(value);
            this.validateVersion(version, exchange2);
            return version;
        }
        catch (Exception ex) {
            throw new InvalidApiVersionException(value, null, ex);
        }
    }

    public void handleDeprecations(Comparable<?> var1, ServerWebExchange var2);
}

