/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.JettyUpgradeListener;
import org.jspecify.annotations.Nullable;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class JettyWebSocketClient
implements WebSocketClient,
Lifecycle {
    private final org.eclipse.jetty.websocket.client.WebSocketClient client;

    public JettyWebSocketClient() {
        this(new org.eclipse.jetty.websocket.client.WebSocketClient());
    }

    public JettyWebSocketClient(org.eclipse.jetty.websocket.client.WebSocketClient client) {
        this.client = client;
    }

    public void start() {
        LifeCycle.start((Object)this.client);
    }

    public void stop() {
        LifeCycle.stop((Object)this.client);
    }

    public boolean isRunning() {
        return this.client.isRunning();
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, null, handler);
    }

    @Override
    public Mono<Void> execute(final URI url, @Nullable HttpHeaders headers, WebSocketHandler handler) {
        ClientUpgradeRequest upgradeRequest = new ClientUpgradeRequest();
        upgradeRequest.setSubProtocols(handler.getSubProtocols());
        if (headers != null) {
            headers.headerNames().forEach(header -> upgradeRequest.setHeader(header, headers.getValuesAsList(header)));
        }
        final AtomicReference handshakeInfo = new AtomicReference();
        JettyUpgradeListener jettyUpgradeListener = new JettyUpgradeListener(){
            final /* synthetic */ JettyWebSocketClient this$0;
            {
                this.this$0 = this$0;
            }

            public void onHandshakeResponse(Request request, Response response) {
                String protocol = response.getHeaders().get(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
                HttpHeaders responseHeaders = new HttpHeaders();
                response.getHeaders().forEach(header -> responseHeaders.add(header.getName(), header.getValue()));
                handshakeInfo.set(new HandshakeInfo(url, responseHeaders, (Mono<Principal>)Mono.empty(), protocol));
            }
        };
        Sinks.Empty completion = Sinks.empty();
        JettyWebSocketHandlerAdapter handlerAdapter = new JettyWebSocketHandlerAdapter(handler, session -> new JettyWebSocketSession((Session)session, Objects.requireNonNull((HandshakeInfo)handshakeInfo.get()), (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, (Sinks.Empty<Void>)completion));
        try {
            this.client.connect((Object)handlerAdapter, url, upgradeRequest, jettyUpgradeListener).exceptionally(throwable -> {
                completion.tryEmitError(throwable);
                return null;
            });
            return completion.asMono();
        }
        catch (IOException ex) {
            return Mono.error((Throwable)ex);
        }
    }
}

