/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.result.view.View;

public final class Fragment {
    private final @Nullable String viewName;
    private final @Nullable View view;
    private @Nullable Map<String, Object> model;

    private Fragment(@Nullable String viewName, @Nullable View view, @Nullable Map<String, Object> model) {
        this.viewName = viewName;
        this.view = view;
        this.model = model;
    }

    public boolean isResolved() {
        return this.view != null;
    }

    public @Nullable String viewName() {
        return this.viewName;
    }

    public View view() {
        Assert.state((this.view != null ? 1 : 0) != 0, (String)"View not resolved");
        return this.view;
    }

    public Map<String, Object> model() {
        return this.model != null ? this.model : Collections.emptyMap();
    }

    public void mergeAttributes(Model model) {
        if (CollectionUtils.isEmpty((Map)model.asMap())) {
            return;
        }
        if (this.model == null) {
            this.model = new LinkedHashMap<String, Object>();
        }
        model.asMap().forEach((key, value) -> this.model.putIfAbsent((String)key, value));
    }

    public String toString() {
        return "Fragment [view=" + this.formatView() + "; model=" + String.valueOf(this.model()) + "]";
    }

    private String formatView() {
        return this.isResolved() ? "\"" + String.valueOf(this.view()) + "\"" : "[" + this.viewName() + "]";
    }

    public static Fragment create(String viewName, Map<String, Object> model) {
        return new Fragment(viewName, null, model);
    }

    public static Fragment create(String viewName) {
        return new Fragment(viewName, null, null);
    }

    public static Fragment create(View view, Map<String, Object> model) {
        return new Fragment(null, view, model);
    }
}

