/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.result.condition.AbstractMediaTypeExpression;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.reactive.result.condition.HeadersRequestCondition;
import org.springframework.web.reactive.result.condition.MediaTypeExpression;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

public final class ProducesRequestCondition
extends AbstractRequestCondition<ProducesRequestCondition> {
    private static final RequestedContentTypeResolver DEFAULT_CONTENT_TYPE_RESOLVER = new RequestedContentTypeResolverBuilder().build();
    private static final ProducesRequestCondition EMPTY_CONDITION = new ProducesRequestCondition(new String[0]);
    private static final String MEDIA_TYPES_ATTRIBUTE = ProducesRequestCondition.class.getName() + ".MEDIA_TYPES";
    private final List<ProduceMediaTypeExpression> mediaTypeAllList = List.of(new ProduceMediaTypeExpression("*/*"));
    private final List<ProduceMediaTypeExpression> expressions;
    private final RequestedContentTypeResolver contentTypeResolver;

    public ProducesRequestCondition(String ... produces) {
        this(produces, (String[])null);
    }

    public ProducesRequestCondition(@Nullable String[] produces, @Nullable String[] headers) {
        this(produces, headers, (RequestedContentTypeResolver)null);
    }

    public ProducesRequestCondition(@Nullable String[] produces, @Nullable String[] headers, @Nullable RequestedContentTypeResolver resolver) {
        this.expressions = this.parseExpressions(produces, headers);
        if (this.expressions.size() > 1) {
            Collections.sort(this.expressions);
        }
        this.contentTypeResolver = resolver != null ? resolver : DEFAULT_CONTENT_TYPE_RESOLVER;
    }

    private List<ProduceMediaTypeExpression> parseExpressions(@Nullable String[] produces, @Nullable String[] headers) {
        LinkedHashSet<ProduceMediaTypeExpression> result = null;
        if (!ObjectUtils.isEmpty((Object[])headers)) {
            for (String header : headers) {
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if (!"Accept".equalsIgnoreCase(expr.name)) continue;
                for (MediaType mediaType : MediaType.parseMediaTypes((String)((String)expr.value))) {
                    result = result != null ? result : new LinkedHashSet<ProduceMediaTypeExpression>();
                    result.add(new ProduceMediaTypeExpression(mediaType, expr.isNegated));
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object[])produces)) {
            for (String produce : produces) {
                result = result != null ? result : new LinkedHashSet<ProduceMediaTypeExpression>();
                result.add(new ProduceMediaTypeExpression(produce));
            }
        }
        return result != null ? new ArrayList(result) : Collections.emptyList();
    }

    private ProducesRequestCondition(List<ProduceMediaTypeExpression> expressions, ProducesRequestCondition other) {
        this.expressions = expressions;
        this.contentTypeResolver = other.contentTypeResolver;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getProducibleMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result.add(expression.getMediaType());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected List<ProduceMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ProducesRequestCondition combine(ProducesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    @Nullable
    public ProducesRequestCondition getMatchingCondition(ServerWebExchange exchange2) {
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange2.getRequest())) {
            return EMPTY_CONDITION;
        }
        if (this.isEmpty()) {
            return this;
        }
        List<ProduceMediaTypeExpression> result = this.getMatchingExpressions(exchange2);
        if (!CollectionUtils.isEmpty(result)) {
            return new ProducesRequestCondition(result, this);
        }
        try {
            if (MediaType.ALL.isPresentIn(this.getAcceptedMediaTypes(exchange2))) {
                return EMPTY_CONDITION;
            }
        }
        catch (NotAcceptableStatusException | UnsupportedMediaTypeStatusException throwable) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private List<ProduceMediaTypeExpression> getMatchingExpressions(ServerWebExchange exchange2) {
        ArrayList<ProduceMediaTypeExpression> result = null;
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (!expression.match(exchange2)) continue;
            result = result != null ? result : new ArrayList<ProduceMediaTypeExpression>();
            result.add(expression);
        }
        return result;
    }

    @Override
    public int compareTo(ProducesRequestCondition other, ServerWebExchange exchange2) {
        if (this.expressions.isEmpty() && other.expressions.isEmpty()) {
            return 0;
        }
        try {
            List<MediaType> acceptedMediaTypes = this.getAcceptedMediaTypes(exchange2);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                int otherIndex;
                int thisIndex = this.indexOfEqualMediaType(acceptedMediaType);
                int result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfEqualMediaType(acceptedMediaType));
                if (result != 0) {
                    return result;
                }
                thisIndex = this.indexOfIncludedMediaType(acceptedMediaType);
                result = this.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfIncludedMediaType(acceptedMediaType));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        catch (NotAcceptableStatusException ex) {
            throw new IllegalStateException("Cannot compare without having any requested media types", ex);
        }
    }

    private List<MediaType> getAcceptedMediaTypes(ServerWebExchange exchange2) throws NotAcceptableStatusException {
        List<MediaType> result = (List<MediaType>)exchange2.getAttribute(MEDIA_TYPES_ATTRIBUTE);
        if (result == null) {
            result = this.contentTypeResolver.resolveMediaTypes(exchange2);
            exchange2.getAttributes().put(MEDIA_TYPES_ATTRIBUTE, result);
        }
        return result;
    }

    private int indexOfEqualMediaType(MediaType mediaType) {
        for (int i2 = 0; i2 < this.getExpressionsToCompare().size(); ++i2) {
            MediaType currentMediaType = this.getExpressionsToCompare().get(i2).getMediaType();
            if (!mediaType.getType().equalsIgnoreCase(currentMediaType.getType()) || !mediaType.getSubtype().equalsIgnoreCase(currentMediaType.getSubtype())) continue;
            return i2;
        }
        return -1;
    }

    private int indexOfIncludedMediaType(MediaType mediaType) {
        for (int i2 = 0; i2 < this.getExpressionsToCompare().size(); ++i2) {
            if (!mediaType.includes(this.getExpressionsToCompare().get(i2).getMediaType())) continue;
            return i2;
        }
        return -1;
    }

    private int compareMatchingMediaTypes(ProducesRequestCondition condition1, int index1, ProducesRequestCondition condition2, int index2) {
        int result = 0;
        if (index1 != index2) {
            result = index2 - index1;
        } else if (index1 != -1) {
            ProduceMediaTypeExpression expr2;
            ProduceMediaTypeExpression expr1 = condition1.getExpressionsToCompare().get(index1);
            result = expr1.compareTo(expr2 = condition2.getExpressionsToCompare().get(index2));
            result = result != 0 ? result : expr1.getMediaType().compareTo((MimeType)expr2.getMediaType());
        }
        return result;
    }

    private List<ProduceMediaTypeExpression> getExpressionsToCompare() {
        return this.expressions.isEmpty() ? this.mediaTypeAllList : this.expressions;
    }

    public static void clearMediaTypesAttribute(ServerWebExchange exchange2) {
        exchange2.getAttributes().remove(MEDIA_TYPES_ATTRIBUTE);
    }

    class ProduceMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ProduceMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        ProduceMediaTypeExpression(String expression) {
            super(expression);
        }

        @Override
        protected boolean matchMediaType(ServerWebExchange exchange2) throws NotAcceptableStatusException {
            List<MediaType> acceptedMediaTypes = ProducesRequestCondition.this.getAcceptedMediaTypes(exchange2);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!this.getMediaType().isCompatibleWith(acceptedMediaType) || !this.matchParameters(acceptedMediaType)) continue;
                return true;
            }
            return false;
        }
    }
}

