/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.TimeZoneAwareLocaleContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.EscapedErrors;
import org.springframework.web.reactive.result.view.BindStatus;
import org.springframework.web.reactive.result.view.RequestDataValueProcessor;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class RequestContext {
    private final ServerWebExchange exchange;
    private final Map<String, Object> model;
    private final MessageSource messageSource;
    private Locale locale;
    private TimeZone timeZone;
    @Nullable
    private Boolean defaultHtmlEscape;
    @Nullable
    private Map<String, Errors> errorsMap;
    @Nullable
    private final RequestDataValueProcessor dataValueProcessor;

    public RequestContext(ServerWebExchange exchange2, Map<String, Object> model, MessageSource messageSource) {
        this(exchange2, model, messageSource, null);
    }

    public RequestContext(ServerWebExchange exchange2, Map<String, Object> model, MessageSource messageSource, @Nullable RequestDataValueProcessor dataValueProcessor) {
        TimeZone timeZone;
        Assert.notNull((Object)exchange2, (String)"ServerWebExchange is required");
        Assert.notNull(model, (String)"Model is required");
        Assert.notNull((Object)messageSource, (String)"MessageSource is required");
        this.exchange = exchange2;
        this.model = model;
        this.messageSource = messageSource;
        LocaleContext localeContext = exchange2.getLocaleContext();
        Locale locale = localeContext.getLocale();
        Locale locale2 = this.locale = locale != null ? locale : Locale.getDefault();
        if (localeContext instanceof TimeZoneAwareLocaleContext) {
            TimeZoneAwareLocaleContext tzaLocaleContext = (TimeZoneAwareLocaleContext)localeContext;
            timeZone = tzaLocaleContext.getTimeZone();
        } else {
            timeZone = null;
        }
        TimeZone timeZone2 = timeZone;
        this.timeZone = timeZone2 != null ? timeZone2 : TimeZone.getDefault();
        this.defaultHtmlEscape = null;
        this.dataValueProcessor = dataValueProcessor;
    }

    protected final ServerWebExchange getExchange() {
        return this.exchange;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Nullable
    public Map<String, Object> getModel() {
        return this.model;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void changeLocale(Locale locale) {
        this.locale = locale;
    }

    public void changeLocale(Locale locale, TimeZone timeZone) {
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public void setDefaultHtmlEscape(boolean defaultHtmlEscape) {
        this.defaultHtmlEscape = defaultHtmlEscape;
    }

    public boolean isDefaultHtmlEscape() {
        return this.defaultHtmlEscape != null && this.defaultHtmlEscape != false;
    }

    @Nullable
    public Boolean getDefaultHtmlEscape() {
        return this.defaultHtmlEscape;
    }

    @Nullable
    public RequestDataValueProcessor getRequestDataValueProcessor() {
        return this.dataValueProcessor;
    }

    public String getContextPath() {
        return this.exchange.getRequest().getPath().contextPath().value();
    }

    public String getContextUrl(String relativeUrl) {
        String url = StringUtils.applyRelativePath((String)(this.getContextPath() + "/"), (String)relativeUrl);
        return this.getExchange().transformUrl(url);
    }

    public String getContextUrl(String relativeUrl, Map<String, ?> params) {
        String url = StringUtils.applyRelativePath((String)(this.getContextPath() + "/"), (String)relativeUrl);
        url = UriComponentsBuilder.fromUriString((String)url).buildAndExpand(params).encode().toUri().toASCIIString();
        return this.getExchange().transformUrl(url);
    }

    public String getRequestPath() {
        return this.exchange.getRequest().getURI().getPath();
    }

    public String getQueryString() {
        return this.exchange.getRequest().getURI().getQuery();
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable Object[] args, String defaultMessage) {
        return this.getMessage(code, args, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable List<?> args, String defaultMessage) {
        return this.getMessage(code, args != null ? args.toArray() : null, defaultMessage, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable Object[] args, String defaultMessage, boolean htmlEscape) {
        String msg = this.messageSource.getMessage(code, args, defaultMessage, this.locale);
        if (msg == null) {
            return "";
        }
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.getMessage(code, null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable Object[] args) throws NoSuchMessageException {
        return this.getMessage(code, args, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable List<?> args) throws NoSuchMessageException {
        return this.getMessage(code, args != null ? args.toArray() : null, this.isDefaultHtmlEscape());
    }

    public String getMessage(String code, @Nullable Object[] args, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.messageSource.getMessage(code, args, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.getMessage(resolvable, this.isDefaultHtmlEscape());
    }

    public String getMessage(MessageSourceResolvable resolvable, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.messageSource.getMessage(resolvable, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    @Nullable
    public Errors getErrors(String name) {
        return this.getErrors(name, this.isDefaultHtmlEscape());
    }

    @Nullable
    public Errors getErrors(String name, boolean htmlEscape) {
        Errors errors;
        if (this.errorsMap == null) {
            this.errorsMap = new HashMap<String, Errors>();
        }
        if ((errors = this.errorsMap.get(name)) == null && (errors = (Errors)this.getModelObject(BindingResult.MODEL_KEY_PREFIX + name)) == null) {
            return null;
        }
        if (errors instanceof BindException) {
            BindException bindException = (BindException)errors;
            errors = bindException.getBindingResult();
        }
        if (htmlEscape && !(errors instanceof EscapedErrors)) {
            errors = new EscapedErrors(errors);
        } else if (!htmlEscape && errors instanceof EscapedErrors) {
            EscapedErrors escapedErrors = (EscapedErrors)errors;
            errors = escapedErrors.getSource();
        }
        this.errorsMap.put(name, errors);
        return errors;
    }

    @Nullable
    protected <T> T getModelObject(String modelName) {
        Object modelObject = this.model.get(modelName);
        if (modelObject == null) {
            modelObject = this.exchange.getAttribute(modelName);
        }
        return (T)modelObject;
    }

    public BindStatus getBindStatus(String path) throws IllegalStateException {
        return new BindStatus(this, path, this.isDefaultHtmlEscape());
    }

    public BindStatus getBindStatus(String path, boolean htmlEscape) throws IllegalStateException {
        return new BindStatus(this, path, htmlEscape);
    }
}

