/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Executable;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ErrorsMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    public ErrorsMethodArgumentResolver(ReactiveAdapterRegistry registry) {
        super(registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterTypeNoReactiveWrapper(parameter, Errors.class::isAssignableFrom);
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        Mono errorsMono;
        String name = this.getModelAttributeName(parameter);
        Object errors = context.getModel().asMap().get(BindingResult.MODEL_KEY_PREFIX + name);
        if (Mono.class.isAssignableFrom(errors.getClass())) {
            errorsMono = (Mono)errors;
        } else if (Errors.class.isAssignableFrom(errors.getClass())) {
            errorsMono = Mono.just(errors);
        } else {
            throw new IllegalStateException("Unexpected Errors/BindingResult type: " + errors.getClass().getName());
        }
        return errorsMono.cast(Object.class);
    }

    private String getModelAttributeName(MethodParameter parameter) {
        Assert.isTrue((parameter.getParameterIndex() > 0 ? 1 : 0) != 0, (String)"Errors argument must be immediately after a model attribute argument");
        int index = parameter.getParameterIndex() - 1;
        MethodParameter attributeParam = MethodParameter.forExecutable((Executable)parameter.getExecutable(), (int)index);
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(attributeParam.getParameterType());
        Assert.isNull((Object)adapter, (String)"Errors/BindingResult cannot be used with an async model attribute. Either declare the model attribute without the async wrapper type or handle WebExchangeBindException through the async type.");
        ModelAttribute ann = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        if (ann != null && StringUtils.hasText((String)ann.value())) {
            return ann.value();
        }
        return Conventions.getVariableNameForParameter((MethodParameter)attributeParam);
    }
}

