/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.SmartHttpMessageConverter;

public abstract class AbstractSmartHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T>
implements SmartHttpMessageConverter<T> {
    protected AbstractSmartHttpMessageConverter() {
    }

    protected AbstractSmartHttpMessageConverter(MediaType supportedMediaType) {
        super(supportedMediaType);
    }

    protected AbstractSmartHttpMessageConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canRead(ResolvableType.forClass(clazz), mediaType);
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canWrite(ResolvableType.forClass(clazz), clazz, mediaType);
    }

    @Override
    public final void write(final T t, final ResolvableType type, @Nullable MediaType contentType, HttpOutputMessage outputMessage, final @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
        final HttpHeaders headers = outputMessage.getHeaders();
        this.addDefaultHeaders(headers, t, contentType);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(new StreamingHttpOutputMessage.Body(){
                final /* synthetic */ AbstractSmartHttpMessageConverter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void writeTo(final OutputStream outputStream) throws IOException {
                    this.this$0.writeInternal(t, type, new HttpOutputMessage(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public OutputStream getBody() {
                            return outputStream;
                        }

                        @Override
                        public HttpHeaders getHeaders() {
                            return headers;
                        }
                    }, hints);
                }

                @Override
                public boolean repeatable() {
                    return this.this$0.supportsRepeatableWrites(t);
                }
            });
        } else {
            this.writeInternal(t, type, outputMessage, hints);
            outputMessage.getBody().flush();
        }
    }

    @Override
    protected void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.writeInternal(t, ResolvableType.NONE, outputMessage, null);
    }

    protected abstract void writeInternal(T var1, ResolvableType var2, HttpOutputMessage var3, @Nullable Map<String, Object> var4) throws IOException, HttpMessageNotWritableException;

    @Override
    protected T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.read(ResolvableType.forClass(clazz), inputMessage, null);
    }
}

