/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.BufferingClientHttpResponseWrapper;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.StreamUtils;

abstract class AbstractBufferingClientHttpRequest
extends AbstractClientHttpRequest {
    private final FastByteArrayOutputStream bufferedOutput = new FastByteArrayOutputStream(1024);

    AbstractBufferingClientHttpRequest() {
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        return this.bufferedOutput;
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        byte[] bytes = this.bufferedOutput.toByteArrayUnsafe();
        if (headers.getContentLength() < 0L) {
            headers.setContentLength(bytes.length);
        }
        ClientHttpResponse result = this.executeInternal(headers, bytes);
        this.bufferedOutput.reset();
        return result;
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1, byte[] var2) throws IOException;

    protected ClientHttpResponse executeWithRequest(ClientHttpRequest request, byte[] bufferedOutput, boolean bufferResponse) throws IOException {
        if (bufferedOutput.length > 0) {
            long contentLength = request.getHeaders().getContentLength();
            if (contentLength > -1L && contentLength != (long)bufferedOutput.length) {
                request.getHeaders().setContentLength(bufferedOutput.length);
            }
            if (request instanceof StreamingHttpOutputMessage) {
                StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)((Object)request);
                streamingOutputMessage.setBody(bufferedOutput);
            } else {
                StreamUtils.copy((byte[])bufferedOutput, (OutputStream)request.getBody());
            }
        }
        ClientHttpResponse response = request.execute();
        return bufferResponse ? new BufferingClientHttpResponseWrapper(response) : response;
    }
}

