/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;
import org.springframework.http.server.PathContainer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.pattern.CaptureTheRestPathElement;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPatternParser;
import org.springframework.web.util.pattern.SeparatorPathElement;
import org.springframework.web.util.pattern.WildcardPathElement;
import org.springframework.web.util.pattern.WildcardTheRestPathElement;

public class PathPattern
implements Comparable<PathPattern> {
    private static final PathContainer EMPTY_PATH = PathContainer.parsePath("");
    public static final Comparator<PathPattern> SPECIFICITY_COMPARATOR = Comparator.nullsLast(Comparator.comparingInt(p -> p.isCatchAll() ? 1 : 0).thenComparingInt(p -> p.isCatchAll() ? PathPattern.scoreByNormalizedLength(p) : 0).thenComparingInt(PathPattern::getScore).thenComparingInt(PathPattern::scoreByNormalizedLength));
    private final String patternString;
    private final PathPatternParser parser;
    private final PathContainer.Options pathOptions;
    private final boolean caseSensitive;
    private final @Nullable PathElement head;
    private int capturedVariableCount;
    private int normalizedLength;
    private boolean endsWithSeparatorWildcard = false;
    private int score;
    private boolean catchAll = false;

    PathPattern(String patternText, PathPatternParser parser, @Nullable PathElement head) {
        this.patternString = patternText;
        this.parser = parser;
        this.pathOptions = parser.getPathOptions();
        this.caseSensitive = parser.isCaseSensitive();
        this.head = head;
        PathElement elem = head;
        while (elem != null) {
            this.capturedVariableCount += elem.getCaptureCount();
            this.normalizedLength += elem.getNormalizedLength();
            this.score += elem.getScore();
            if (elem instanceof CaptureTheRestPathElement || elem instanceof WildcardTheRestPathElement) {
                this.catchAll = true;
            }
            if (elem instanceof SeparatorPathElement && elem.next instanceof WildcardPathElement && elem.next.next == null) {
                this.endsWithSeparatorWildcard = true;
            }
            elem = elem.next;
        }
    }

    public String getPatternString() {
        return this.patternString;
    }

    public boolean hasPatternSyntax() {
        return this.score > 0 || this.catchAll || this.patternString.indexOf(63) != -1;
    }

    public boolean matches(PathContainer pathContainer) {
        if (this.head == null) {
            return !this.hasLength(pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                pathContainer = EMPTY_PATH;
            } else {
                return false;
            }
        }
        MatchingContext matchingContext = new MatchingContext(pathContainer, false);
        return this.head.matches(0, matchingContext);
    }

    public @Nullable PathMatchInfo matchAndExtract(PathContainer pathContainer) {
        MatchingContext matchingContext;
        if (this.head == null) {
            return this.hasLength(pathContainer) && !this.pathContainerIsJustSeparator(pathContainer) ? null : PathMatchInfo.EMPTY;
        }
        if (!this.hasLength(pathContainer)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                pathContainer = EMPTY_PATH;
            } else {
                return null;
            }
        }
        return this.head.matches(0, matchingContext = new MatchingContext(pathContainer, true)) ? matchingContext.getPathMatchResult() : null;
    }

    public @Nullable PathRemainingMatchInfo matchStartOfPath(PathContainer pathContainer) {
        PathContainer pathRemaining;
        PathContainer pathMatched;
        if (this.head == null) {
            return new PathRemainingMatchInfo(EMPTY_PATH, pathContainer);
        }
        if (!this.hasLength(pathContainer)) {
            return null;
        }
        MatchingContext matchingContext = new MatchingContext(pathContainer, true);
        matchingContext.setMatchAllowExtraPath();
        boolean matches = this.head.matches(0, matchingContext);
        if (!matches) {
            return null;
        }
        if (matchingContext.remainingPathIndex == pathContainer.elements().size()) {
            pathMatched = pathContainer;
            pathRemaining = EMPTY_PATH;
        } else {
            pathMatched = pathContainer.subPath(0, matchingContext.remainingPathIndex);
            pathRemaining = pathContainer.subPath(matchingContext.remainingPathIndex);
        }
        return new PathRemainingMatchInfo(pathMatched, pathRemaining, matchingContext.getPathMatchResult());
    }

    public PathContainer extractPathWithinPattern(PathContainer path) {
        int endIndex;
        List<PathContainer.Element> pathElements = path.elements();
        int pathElementsCount = pathElements.size();
        int startIndex = 0;
        PathElement elem = this.head;
        while (elem != null && elem.isLiteral()) {
            elem = elem.next;
            ++startIndex;
        }
        if (elem == null) {
            return PathContainer.parsePath("");
        }
        while (startIndex < pathElementsCount && pathElements.get(startIndex) instanceof PathContainer.Separator) {
            ++startIndex;
        }
        for (endIndex = pathElements.size(); endIndex > 0 && pathElements.get(endIndex - 1) instanceof PathContainer.Separator; --endIndex) {
        }
        boolean multipleAdjacentSeparators = false;
        for (int i = startIndex; i < endIndex - 1; ++i) {
            if (!(pathElements.get(i) instanceof PathContainer.Separator) || !(pathElements.get(i + 1) instanceof PathContainer.Separator)) continue;
            multipleAdjacentSeparators = true;
            break;
        }
        PathContainer resultPath = null;
        if (multipleAdjacentSeparators) {
            StringBuilder sb = new StringBuilder();
            int i = startIndex;
            while (i < endIndex) {
                PathContainer.Element e = pathElements.get(i++);
                sb.append(e.value());
                if (!(e instanceof PathContainer.Separator)) continue;
                while (i < endIndex && pathElements.get(i) instanceof PathContainer.Separator) {
                    ++i;
                }
            }
            resultPath = PathContainer.parsePath(sb.toString(), this.pathOptions);
        } else {
            resultPath = startIndex >= endIndex ? PathContainer.parsePath("") : path.subPath(startIndex, endIndex);
        }
        return resultPath;
    }

    @Override
    public int compareTo(@Nullable PathPattern otherPattern) {
        int result = SPECIFICITY_COMPARATOR.compare(this, otherPattern);
        return result == 0 && otherPattern != null ? this.patternString.compareTo(otherPattern.patternString) : result;
    }

    public PathPattern combine(PathPattern otherPattern) {
        boolean isSecondExtensionWildcard;
        if (!StringUtils.hasLength((String)this.patternString)) {
            if (!StringUtils.hasLength((String)otherPattern.patternString)) {
                return this.parser.parse("");
            }
            return otherPattern;
        }
        if (!StringUtils.hasLength((String)otherPattern.patternString)) {
            return this;
        }
        if (!this.patternString.equals(otherPattern.patternString) && this.capturedVariableCount == 0 && this.matches(PathContainer.parsePath(otherPattern.patternString))) {
            return otherPattern;
        }
        if (this.endsWithSeparatorWildcard) {
            String prefix = this.patternString.length() > 2 ? this.patternString.substring(0, this.patternString.length() - 2) : String.valueOf(this.getSeparator());
            return this.parser.parse(this.concat(prefix, otherPattern.patternString));
        }
        if (this.catchAll) {
            return this.parser.parse(this.concat(this.patternString.substring(0, this.patternString.length() - 3), otherPattern.patternString));
        }
        int firstStarDotPos = this.patternString.indexOf("*.");
        if (this.capturedVariableCount != 0 || firstStarDotPos == -1 || this.getSeparator() == '.') {
            return this.parser.parse(this.concat(this.patternString, otherPattern.patternString));
        }
        int secondDotPos = otherPattern.patternString.indexOf(46);
        String firstExtension = this.patternString.substring(firstStarDotPos + 1);
        String secondExtension = secondDotPos == -1 ? "" : otherPattern.patternString.substring(secondDotPos);
        boolean isFirstExtensionWildcard = firstExtension.equals(".*") || firstExtension.isEmpty();
        boolean bl = isSecondExtensionWildcard = secondExtension.equals(".*") || secondExtension.isEmpty();
        if (!isFirstExtensionWildcard && !isSecondExtensionWildcard) {
            throw new IllegalArgumentException("Cannot combine patterns: " + this.patternString + " and " + String.valueOf(otherPattern));
        }
        String firstPath = this.patternString.substring(0, this.patternString.lastIndexOf(this.getSeparator()));
        String secondPath = otherPattern.patternString.substring(0, otherPattern.patternString.lastIndexOf(this.getSeparator()));
        if (!this.parser.parse(firstPath).matches(PathContainer.parsePath(secondPath))) {
            throw new IllegalArgumentException("Cannot combine patterns: " + this.patternString + " and " + String.valueOf(otherPattern));
        }
        String secondFile = secondDotPos == -1 ? otherPattern.patternString : otherPattern.patternString.substring(0, secondDotPos);
        return this.parser.parse(secondFile + (isFirstExtensionWildcard ? secondExtension : firstExtension));
    }

    public boolean equals(@Nullable Object other) {
        PathPattern that;
        return this == other || other instanceof PathPattern && this.patternString.equals((that = (PathPattern)other).getPatternString()) && this.getSeparator() == that.getSeparator() && this.caseSensitive == that.caseSensitive;
    }

    public int hashCode() {
        return (this.patternString.hashCode() + this.getSeparator()) * 17 + (this.caseSensitive ? 1 : 0);
    }

    public String toString() {
        return this.patternString;
    }

    int getScore() {
        return this.score;
    }

    boolean isCatchAll() {
        return this.catchAll;
    }

    int getNormalizedLength() {
        return this.normalizedLength;
    }

    char getSeparator() {
        return this.pathOptions.separator();
    }

    int getCapturedVariableCount() {
        return this.capturedVariableCount;
    }

    String toChainString() {
        StringJoiner stringJoiner = new StringJoiner(" ");
        PathElement pe = this.head;
        while (pe != null) {
            stringJoiner.add(pe.toString());
            pe = pe.next;
        }
        return stringJoiner.toString();
    }

    String computePatternString() {
        StringBuilder sb = new StringBuilder();
        PathElement pe = this.head;
        while (pe != null) {
            sb.append(pe.getChars());
            pe = pe.next;
        }
        return sb.toString();
    }

    @Nullable PathElement getHeadSection() {
        return this.head;
    }

    private String concat(String path1, String path2) {
        boolean path2StartsWithSeparator;
        boolean path1EndsWithSeparator = path1.charAt(path1.length() - 1) == this.getSeparator();
        boolean bl = path2StartsWithSeparator = path2.charAt(0) == this.getSeparator();
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (path1EndsWithSeparator || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return path1 + this.getSeparator() + path2;
    }

    private boolean hasLength(@Nullable PathContainer container) {
        return container != null && container.elements().size() > 0;
    }

    private static int scoreByNormalizedLength(PathPattern pattern) {
        return -pattern.getNormalizedLength();
    }

    private boolean pathContainerIsJustSeparator(PathContainer pathContainer) {
        return pathContainer.value().length() == 1 && pathContainer.value().charAt(0) == this.getSeparator();
    }

    static class MatchingContext {
        final PathContainer candidate;
        final List<PathContainer.Element> pathElements;
        final int pathLength;
        private @Nullable Map<String, String> extractedUriVariables;
        private @Nullable Map<String, MultiValueMap<String, String>> extractedMatrixVariables;
        boolean extractingVariables;
        boolean determineRemainingPath = false;
        int remainingPathIndex;

        public MatchingContext(PathContainer pathContainer, boolean extractVariables) {
            this.candidate = pathContainer;
            this.pathElements = pathContainer.elements();
            this.pathLength = this.pathElements.size();
            this.extractingVariables = extractVariables;
        }

        public void setMatchAllowExtraPath() {
            this.determineRemainingPath = true;
        }

        public void set(String key, String value, MultiValueMap<String, String> parameters) {
            if (this.extractedUriVariables == null) {
                this.extractedUriVariables = new HashMap<String, String>();
            }
            this.extractedUriVariables.put(key, value);
            if (!parameters.isEmpty()) {
                if (this.extractedMatrixVariables == null) {
                    this.extractedMatrixVariables = new HashMap<String, MultiValueMap<String, String>>();
                }
                this.extractedMatrixVariables.put(key, (MultiValueMap<String, String>)CollectionUtils.unmodifiableMultiValueMap(parameters));
            }
        }

        public PathMatchInfo getPathMatchResult() {
            if (this.extractedUriVariables == null) {
                return PathMatchInfo.EMPTY;
            }
            return new PathMatchInfo(this.extractedUriVariables, this.extractedMatrixVariables);
        }

        boolean isSeparator(int pathIndex) {
            return this.pathElements.get(pathIndex) instanceof PathContainer.Separator;
        }

        String pathElementValue(int pathIndex) {
            String string;
            PathContainer.Element element;
            PathContainer.Element element2 = element = pathIndex < this.pathLength ? this.pathElements.get(pathIndex) : null;
            if (element instanceof PathContainer.PathSegment) {
                PathContainer.PathSegment pathSegment = (PathContainer.PathSegment)element;
                string = pathSegment.valueToMatch();
            } else {
                string = "";
            }
            return string;
        }
    }

    public static class PathMatchInfo {
        private static final PathMatchInfo EMPTY = new PathMatchInfo(Collections.emptyMap(), Collections.emptyMap());
        private final Map<String, String> uriVariables;
        private final Map<String, MultiValueMap<String, String>> matrixVariables;

        PathMatchInfo(Map<String, String> uriVars, @Nullable Map<String, MultiValueMap<String, String>> matrixVars) {
            this.uriVariables = Collections.unmodifiableMap(uriVars);
            this.matrixVariables = matrixVars != null ? Collections.unmodifiableMap(matrixVars) : Collections.emptyMap();
        }

        public Map<String, String> getUriVariables() {
            return this.uriVariables;
        }

        public Map<String, MultiValueMap<String, String>> getMatrixVariables() {
            return this.matrixVariables;
        }

        public String toString() {
            return "PathMatchInfo[uriVariables=" + String.valueOf(this.uriVariables) + ", matrixVariables=" + String.valueOf(this.matrixVariables) + "]";
        }
    }

    public static class PathRemainingMatchInfo {
        private final PathContainer pathMatched;
        private final PathContainer pathRemaining;
        private final PathMatchInfo pathMatchInfo;

        PathRemainingMatchInfo(PathContainer pathMatched, PathContainer pathRemaining) {
            this(pathMatched, pathRemaining, PathMatchInfo.EMPTY);
        }

        PathRemainingMatchInfo(PathContainer pathMatched, PathContainer pathRemaining, PathMatchInfo pathMatchInfo) {
            this.pathRemaining = pathRemaining;
            this.pathMatched = pathMatched;
            this.pathMatchInfo = pathMatchInfo;
        }

        public PathContainer getPathMatched() {
            return this.pathMatched;
        }

        public PathContainer getPathRemaining() {
            return this.pathRemaining;
        }

        public Map<String, String> getUriVariables() {
            return this.pathMatchInfo.getUriVariables();
        }

        public Map<String, MultiValueMap<String, String>> getMatrixVariables() {
            return this.pathMatchInfo.getMatrixVariables();
        }
    }
}

