/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.net.URI;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.DefaultApiVersionInserterBuilder;

public interface ApiVersionInserter {
    default public URI insertVersion(Object version, URI uri) {
        return uri;
    }

    default public void insertVersion(Object version, HttpHeaders headers) {
    }

    public static ApiVersionInserter useHeader(@Nullable String header) {
        return new DefaultApiVersionInserterBuilder(header, null, null).build();
    }

    public static ApiVersionInserter useQueryParam(@Nullable String queryParam) {
        return new DefaultApiVersionInserterBuilder(null, queryParam, null).build();
    }

    public static ApiVersionInserter usePathSegment(@Nullable Integer pathSegmentIndex) {
        return new DefaultApiVersionInserterBuilder(null, null, pathSegmentIndex).build();
    }

    public static Builder builder() {
        return new DefaultApiVersionInserterBuilder(null, null, null);
    }

    public static interface Builder {
        public Builder useHeader(@Nullable String var1);

        public Builder useQueryParam(@Nullable String var1);

        public Builder usePathSegment(@Nullable Integer var1);

        public Builder withVersionFormatter(ApiVersionFormatter var1);

        public ApiVersionInserter build();
    }
}

