/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpServiceProxyFactory;
import org.springframework.web.service.registry.GroupsMetadata;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupAdapter;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceProxyRegistry;

public final class HttpServiceProxyRegistryFactoryBean
implements ApplicationContextAware,
InitializingBean,
FactoryBean<HttpServiceProxyRegistry> {
    private static final Map<HttpServiceGroup.ClientType, HttpServiceGroupAdapter<?>> groupAdapters = GroupAdapterInitializer.initGroupAdapters();
    private final Set<ProxyHttpServiceGroup> groupSet;
    private @Nullable ApplicationContext applicationContext;
    private @Nullable HttpServiceProxyRegistry proxyRegistry;

    HttpServiceProxyRegistryFactoryBean(GroupsMetadata groupsMetadata) {
        this.groupSet = groupsMetadata.groups().stream().map(group -> {
            HttpServiceGroupAdapter<?> adapter = groupAdapters.get((Object)group.clientType());
            Assert.state((adapter != null ? 1 : 0) != 0, (String)("No HttpServiceGroupAdapter for type " + String.valueOf((Object)group.clientType())));
            return new ProxyHttpServiceGroup((HttpServiceGroup)group, adapter);
        }).collect(Collectors.toSet());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Class<?> getObjectType() {
        return HttpServiceProxyRegistry.class;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext not initialized");
        groupAdapters.forEach((clientType, groupAdapter) -> this.applicationContext.getBeanProvider(groupAdapter.getConfigurerType()).orderedStream().forEach(configurer -> configurer.configureGroups(new DefaultGroups((HttpServiceGroup.ClientType)((Object)clientType)))));
        Map<String, Map<Class<?>, Object>> groupProxyMap = this.groupSet.stream().collect(Collectors.toMap(ProxyHttpServiceGroup::name, ProxyHttpServiceGroup::createProxies));
        this.proxyRegistry = new DefaultHttpServiceProxyRegistry(groupProxyMap);
    }

    public HttpServiceProxyRegistry getObject() {
        Assert.state((this.proxyRegistry != null ? 1 : 0) != 0, (String)"HttpServiceProxyRegistry not initialized");
        return this.proxyRegistry;
    }

    private static final class DefaultHttpServiceProxyRegistry
    implements HttpServiceProxyRegistry {
        private final Map<String, Map<Class<?>, Object>> groupProxyMap;
        private final MultiValueMap<Class<?>, Object> directLookupMap;

        DefaultHttpServiceProxyRegistry(Map<String, Map<Class<?>, Object>> groupProxyMap) {
            this.groupProxyMap = groupProxyMap;
            this.directLookupMap = new LinkedMultiValueMap();
            groupProxyMap.values().forEach(map -> map.forEach((arg_0, arg_1) -> this.directLookupMap.add(arg_0, arg_1)));
        }

        @Override
        public <P> P getClient(Class<P> type) {
            List map = (List)this.directLookupMap.getOrDefault(type, Collections.emptyList());
            Assert.notEmpty((Collection)map, (String)("No client of type " + type.getName()));
            Assert.isTrue((map.size() <= 1 ? 1 : 0) != 0, (String)("No unique client of type " + type.getName()));
            return (P)map.get(0);
        }

        @Override
        public <P> P getClient(String groupName, Class<P> type) {
            Map<Class<?>, Object> map = this.getProxyMapForGroup(groupName);
            Object proxy = map.get(type);
            Assert.notNull((Object)proxy, (String)("No client of type " + String.valueOf(type) + " in group '" + groupName + "': " + String.valueOf(map.keySet())));
            return (P)proxy;
        }

        @Override
        public Set<String> getGroupNames() {
            return this.groupProxyMap.keySet();
        }

        @Override
        public Set<Class<?>> getClientTypesInGroup(String groupName) {
            return this.getProxyMapForGroup(groupName).keySet();
        }

        private Map<Class<?>, Object> getProxyMapForGroup(String groupName) {
            Map<Class<?>, Object> map = this.groupProxyMap.get(groupName);
            Assert.notNull(map, (String)("No group with name '" + groupName + "'"));
            return map;
        }
    }

    private final class DefaultGroups<CB>
    implements HttpServiceGroupConfigurer.Groups<CB> {
        private Predicate<HttpServiceGroup> filter = group -> group.clientType().equals((Object)clientType);

        DefaultGroups(HttpServiceGroup.ClientType clientType) {
        }

        @Override
        public HttpServiceGroupConfigurer.Groups<CB> filterByName(String ... groupNames) {
            return this.filter(group -> Arrays.stream(groupNames).anyMatch(id -> id.equals(group.name())));
        }

        @Override
        public HttpServiceGroupConfigurer.Groups<CB> filter(Predicate<HttpServiceGroup> predicate) {
            this.filter = this.filter.or(predicate);
            return this;
        }

        @Override
        public void configureClient(Consumer<CB> clientConfigurer) {
            this.configureClient((HttpServiceGroup group, CB builder) -> clientConfigurer.accept(builder));
        }

        @Override
        public void configureClient(BiConsumer<HttpServiceGroup, CB> clientConfigurer) {
            this.configure(clientConfigurer, (group, builder) -> {});
        }

        @Override
        public void configureProxyFactory(BiConsumer<HttpServiceGroup, HttpServiceProxyFactory.Builder> proxyFactoryConfigurer) {
            this.configure((group, builder) -> {}, proxyFactoryConfigurer);
        }

        @Override
        public void configure(BiConsumer<HttpServiceGroup, CB> clientConfigurer, BiConsumer<HttpServiceGroup, HttpServiceProxyFactory.Builder> proxyFactoryConfigurer) {
            HttpServiceProxyRegistryFactoryBean.this.groupSet.stream().filter(this.filter).forEach(group -> group.apply(clientConfigurer, proxyFactoryConfigurer));
        }
    }

    private static final class ProxyHttpServiceGroup
    implements HttpServiceGroup {
        private final HttpServiceGroup declaredGroup;
        private final HttpServiceGroupAdapter<?> groupAdapter;
        private final Object clientBuilder;
        private BiConsumer<HttpServiceGroup, HttpServiceProxyFactory.Builder> proxyFactoryConfigurer = (group, builder) -> {};

        ProxyHttpServiceGroup(HttpServiceGroup group2, HttpServiceGroupAdapter<?> groupAdapter) {
            this.declaredGroup = group2;
            this.groupAdapter = groupAdapter;
            this.clientBuilder = groupAdapter.createClientBuilder();
        }

        @Override
        public String name() {
            return this.declaredGroup.name();
        }

        @Override
        public Set<Class<?>> httpServiceTypes() {
            return this.declaredGroup.httpServiceTypes();
        }

        @Override
        public HttpServiceGroup.ClientType clientType() {
            return this.declaredGroup.clientType();
        }

        public <CB> void apply(BiConsumer<HttpServiceGroup, CB> clientConfigurer, BiConsumer<HttpServiceGroup, HttpServiceProxyFactory.Builder> proxyFactoryConfigurer) {
            clientConfigurer.accept(this, this.clientBuilder);
            this.proxyFactoryConfigurer = this.proxyFactoryConfigurer.andThen(proxyFactoryConfigurer);
        }

        public Map<Class<?>, Object> createProxies() {
            LinkedHashMap map = new LinkedHashMap(this.httpServiceTypes().size());
            HttpExchangeAdapter exchangeAdapter = this.initExchangeAdapter();
            HttpServiceProxyFactory.Builder proxyFactoryBuilder = HttpServiceProxyFactory.builderFor(exchangeAdapter);
            this.proxyFactoryConfigurer.accept(this, proxyFactoryBuilder);
            HttpServiceProxyFactory factory = proxyFactoryBuilder.build();
            this.httpServiceTypes().forEach(type -> map.put((Class<?>)type, factory.createClient(type)));
            return map;
        }

        private <CB> HttpExchangeAdapter initExchangeAdapter() {
            return this.groupAdapter.createExchangeAdapter(this.clientBuilder);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[id=" + this.name() + "]";
        }
    }

    private static class GroupAdapterInitializer {
        private GroupAdapterInitializer() {
        }

        static Map<HttpServiceGroup.ClientType, HttpServiceGroupAdapter<?>> initGroupAdapters() {
            LinkedHashMap map = new LinkedHashMap(2);
            GroupAdapterInitializer.addGroupAdapter(map, HttpServiceGroup.ClientType.REST_CLIENT, "org.springframework.web.client.support.RestClientHttpServiceGroupAdapter");
            GroupAdapterInitializer.addGroupAdapter(map, HttpServiceGroup.ClientType.WEB_CLIENT, "org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupAdapter");
            return map;
        }

        private static void addGroupAdapter(Map<HttpServiceGroup.ClientType, HttpServiceGroupAdapter<?>> groupAdapters, HttpServiceGroup.ClientType clientType, String className) {
            try {
                Class clazz = ClassUtils.forName((String)className, (ClassLoader)HttpServiceGroupAdapter.class.getClassLoader());
                groupAdapters.put(clientType, (HttpServiceGroupAdapter)BeanUtils.instantiateClass((Class)clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

