/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;

public abstract class AbstractGenericHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T>
implements GenericHttpMessageConverter<T> {
    protected AbstractGenericHttpMessageConverter() {
    }

    protected AbstractGenericHttpMessageConverter(MediaType supportedMediaType) {
        super(supportedMediaType);
    }

    protected AbstractGenericHttpMessageConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    protected AbstractGenericHttpMessageConverter(Charset defaultCharset, MediaType ... supportedMediaTypes) {
        super(defaultCharset, supportedMediaTypes);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        boolean bl;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            bl = this.canRead(clazz, mediaType);
        } else {
            bl = this.canRead(mediaType);
        }
        return bl;
    }

    @Override
    public boolean canWrite(@Nullable Type type, Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canWrite(clazz, mediaType);
    }

    @Override
    public final void write(final T t, final @Nullable Type type, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        final HttpHeaders headers = outputMessage.getHeaders();
        this.addDefaultHeaders(headers, t, contentType);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(new StreamingHttpOutputMessage.Body(){
                final /* synthetic */ AbstractGenericHttpMessageConverter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void writeTo(final OutputStream outputStream) throws IOException {
                    this.this$0.writeInternal(t, type, new HttpOutputMessage(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public OutputStream getBody() {
                            return outputStream;
                        }

                        @Override
                        public HttpHeaders getHeaders() {
                            return this.this$1.headers;
                        }
                    });
                }

                @Override
                public boolean repeatable() {
                    return this.this$0.supportsRepeatableWrites(t);
                }
            });
        } else {
            this.writeInternal(t, type, outputMessage);
            outputMessage.getBody().flush();
        }
    }

    @Override
    protected void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.writeInternal(t, null, outputMessage);
    }

    protected abstract void writeInternal(T var1, @Nullable Type var2, HttpOutputMessage var3) throws IOException, HttpMessageNotWritableException;
}

