/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.web.context.scope.RequestAttributes;
import org.springframework.web.context.scope.RequestContextHolder;

public abstract class AbstractRequestAttributesScope
implements Scope {
    public Object get(String name, ObjectFactory objectFactory) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = attributes.getAttribute(name, this.getScope());
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            attributes.setAttribute(name, scopedObject, this.getScope());
        }
        return scopedObject;
    }

    public Object remove(String name) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = attributes.getAttribute(name, this.getScope());
        if (scopedObject != null) {
            attributes.removeAttribute(name, this.getScope());
            return scopedObject;
        }
        return null;
    }

    protected abstract int getScope();
}

