/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.util.Assert;
import org.springframework.web.context.scope.RequestAttributes;
import org.springframework.web.util.WebUtils;

public class ServletRequestAttributes
implements RequestAttributes {
    private final HttpServletRequest request;
    private final Map sessionAttributesToUpdate = new HashMap();

    public ServletRequestAttributes(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        this.request = request;
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 0) {
            return this.request.getAttribute(name);
        }
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            Object value = session.getAttribute(name);
            if (value != null) {
                this.sessionAttributesToUpdate.put(name, value);
            }
            return value;
        }
        return null;
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 0) {
            this.request.setAttribute(name, value);
        } else {
            HttpSession session = this.request.getSession(true);
            session.setAttribute(name, value);
            this.sessionAttributesToUpdate.remove(name);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 0) {
            this.request.removeAttribute(name);
        } else {
            HttpSession session = this.request.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
                this.sessionAttributesToUpdate.remove(name);
            }
        }
    }

    public Object getSessionMutex() {
        return WebUtils.getSessionMutex(this.request.getSession());
    }

    public void updateAccessedAttributes() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            Iterator it = this.sessionAttributesToUpdate.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                Object newValue = entry.getValue();
                Object oldValue = session.getAttribute(name);
                if (oldValue != newValue) continue;
                session.setAttribute(name, newValue);
            }
        }
        this.sessionAttributesToUpdate.clear();
    }
}

