/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.scope;

import java.util.Locale;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.scope.RequestContextHolder;
import org.springframework.web.context.scope.ServletRequestAttributes;

public class RequestContextListener
implements ServletRequestListener {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (!(requestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + requestEvent.getServletRequest());
        }
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        LocaleContextHolder.setLocale((Locale)request.getLocale());
        RequestContextHolder.setRequestAttributes(new ServletRequestAttributes(request));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Bound request context to thread: " + request));
        }
    }

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        requestAttributes.updateAccessedAttributes();
        RequestContextHolder.setRequestAttributes(null);
        LocaleContextHolder.setLocale(null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cleared thread-bound request context: " + requestEvent.getServletRequest()));
        }
    }
}

