/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.hint;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.test.context.cache.DefaultCacheAwareContextLoaderDelegate;
import org.springframework.test.context.support.DefaultBootstrapContext;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.util.ClassUtils;

class TestContextRuntimeHints
implements RuntimeHintsRegistrar {
    TestContextRuntimeHints() {
    }

    public void registerHints(RuntimeHints runtimeHints, @Nullable ClassLoader classLoader) {
        boolean servletPresent = ClassUtils.isPresent((String)"jakarta.servlet.Servlet", (ClassLoader)classLoader);
        boolean groovyPresent = ClassUtils.isPresent((String)"groovy.lang.Closure", (ClassLoader)classLoader);
        ReflectionHints reflectionHints = runtimeHints.reflection();
        TestContextRuntimeHints.registerPublicConstructors(reflectionHints, DefaultCacheAwareContextLoaderDelegate.class, DefaultBootstrapContext.class);
        if (groovyPresent) {
            TestContextRuntimeHints.registerDeclaredConstructors(reflectionHints, "org.springframework.test.context.support.GenericGroovyXmlContextLoader");
            if (servletPresent) {
                TestContextRuntimeHints.registerDeclaredConstructors(reflectionHints, "org.springframework.test.context.web.GenericGroovyXmlWebContextLoader");
            }
        }
        TestContextRuntimeHints.registerAnnotation(reflectionHints, WebAppConfiguration.class);
    }

    private static void registerPublicConstructors(ReflectionHints reflectionHints, Class<?> ... types) {
        reflectionHints.registerTypes((Iterable)TypeReference.listOf((Class[])types), TypeHint.builtWith((MemberCategory[])new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS}));
    }

    private static void registerDeclaredConstructors(ReflectionHints reflectionHints, String ... classNames) {
        reflectionHints.registerTypes(TestContextRuntimeHints.listOf(classNames), TypeHint.builtWith((MemberCategory[])new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
    }

    private static List<TypeReference> listOf(String ... classNames) {
        return Arrays.stream(classNames).map(TypeReference::of).toList();
    }

    private static void registerAnnotation(ReflectionHints reflectionHints, Class<? extends Annotation> annotationType) {
        reflectionHints.registerType(annotationType, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS});
    }
}

