/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class PassThroughFilterChain
implements FilterChain {
    private @Nullable Filter filter;
    private @Nullable FilterChain nextFilterChain;
    private @Nullable Servlet servlet;

    public PassThroughFilterChain(Filter filter, FilterChain nextFilterChain) {
        Assert.notNull((Object)filter, (String)"Filter must not be null");
        Assert.notNull((Object)nextFilterChain, (String)"'FilterChain must not be null");
        this.filter = filter;
        this.nextFilterChain = nextFilterChain;
    }

    public PassThroughFilterChain(Servlet servlet) {
        Assert.notNull((Object)servlet, (String)"Servlet must not be null");
        this.servlet = servlet;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.filter != null) {
            this.filter.doFilter(request, response, this.nextFilterChain);
        } else {
            Assert.state((this.servlet != null ? 1 : 0) != 0, (String)"Neither a Filter nor a Servlet has been set");
            this.servlet.service(request, response);
        }
    }
}

