/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.StringUtils;

public class WebMergedContextConfiguration
extends MergedContextConfiguration {
    private static final long serialVersionUID = 7323361588604247458L;
    private final String resourceBasePath;

    public WebMergedContextConfiguration(MergedContextConfiguration mergedConfig, String resourceBasePath) {
        super(mergedConfig);
        this.resourceBasePath = StringUtils.hasText((String)resourceBasePath) ? resourceBasePath : "";
    }

    @Deprecated(since="6.1")
    public WebMergedContextConfiguration(Class<?> testClass, String @Nullable [] locations, Class<?> @Nullable [] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, String @Nullable [] activeProfiles, String @Nullable [] propertySourceLocations, String @Nullable [] propertySourceProperties, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceLocations, propertySourceProperties, null, resourceBasePath, contextLoader, cacheAwareContextLoaderDelegate, parent);
    }

    @Deprecated(since="6.1")
    public WebMergedContextConfiguration(Class<?> testClass, String @Nullable [] locations, Class<?> @Nullable [] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, String @Nullable [] activeProfiles, String @Nullable [] propertySourceLocations, String @Nullable [] propertySourceProperties, @Nullable Set<ContextCustomizer> contextCustomizers, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, List.of(new PropertySourceDescriptor(WebMergedContextConfiguration.processStrings(propertySourceLocations))), propertySourceProperties, contextCustomizers, resourceBasePath, contextLoader, cacheAwareContextLoaderDelegate, parent);
    }

    public WebMergedContextConfiguration(Class<?> testClass, String @Nullable [] locations, Class<?> @Nullable [] classes, @Nullable Set<Class<? extends ApplicationContextInitializer<?>>> contextInitializerClasses, String @Nullable [] activeProfiles, List<PropertySourceDescriptor> propertySourceDescriptors, String @Nullable [] propertySourceProperties, @Nullable Set<ContextCustomizer> contextCustomizers, String resourceBasePath, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, @Nullable MergedContextConfiguration parent) {
        super(testClass, locations, classes, contextInitializerClasses, activeProfiles, propertySourceDescriptors, propertySourceProperties, contextCustomizers, contextLoader, cacheAwareContextLoaderDelegate, parent);
        this.resourceBasePath = StringUtils.hasText((String)resourceBasePath) ? resourceBasePath : "";
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!super.equals(other)) return false;
        if (!(other instanceof WebMergedContextConfiguration)) return false;
        WebMergedContextConfiguration otherConfiguration = (WebMergedContextConfiguration)other;
        if (!this.resourceBasePath.equals(otherConfiguration.resourceBasePath)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.resourceBasePath.hashCode();
    }

    @Override
    public String toString() {
        return new ToStringCreator((Object)this, (ToStringStyler)new DefaultToStringStyler((ValueStyler)new SimpleValueStyler())).append("testClass", this.getTestClass()).append("locations", (Object)this.getLocations()).append("classes", this.getClasses()).append("contextInitializerClasses", this.getContextInitializerClasses()).append("activeProfiles", (Object)this.getActiveProfiles()).append("propertySourceDescriptors", this.getPropertySourceDescriptors()).append("propertySourceProperties", (Object)this.getPropertySourceProperties()).append("contextCustomizers", this.getContextCustomizers()).append("resourceBasePath", (Object)this.getResourceBasePath()).append("contextLoader", this.getContextLoader() != null ? this.getContextLoader().getClass() : null).append("parent", (Object)this.getParent()).toString();
    }
}

