/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class HeaderResultMatchers {
    protected HeaderResultMatchers() {
    }

    public ResultMatcher string(final String name, final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                MatcherAssert.assertThat((String)("Response header " + name), (Object)result.getResponse().getHeader(name), (Matcher)matcher);
            }
        };
    }

    public ResultMatcher string(final String name, final String value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertEquals("Response header " + name, value, result.getResponse().getHeader(name));
            }
        };
    }

    public ResultMatcher doesNotExist(final String name) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertTrue("Response should not contain header " + name, !result.getResponse().containsHeader(name));
            }
        };
    }

    public ResultMatcher longValue(final String name, final long value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                AssertionErrors.assertTrue("Response does not contain header " + name, result.getResponse().containsHeader(name));
                AssertionErrors.assertEquals("Response header " + name, value, Long.parseLong(result.getResponse().getHeader(name)));
            }
        };
    }

    public ResultMatcher dateValue(final String name, final long value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) {
                SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                AssertionErrors.assertTrue("Response does not contain header " + name, result.getResponse().containsHeader(name));
                AssertionErrors.assertEquals("Response header " + name, format.format(new Date(value)), result.getResponse().getHeader(name));
            }
        };
    }
}

