/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.DefaultTestContext;
import org.springframework.test.context.MetaAnnotationUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class TestContextManager {
    private static final String[] DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES = new String[]{"org.springframework.test.context.web.ServletTestExecutionListener", "org.springframework.test.context.support.DependencyInjectionTestExecutionListener", "org.springframework.test.context.support.DirtiesContextTestExecutionListener", "org.springframework.test.context.transaction.TransactionalTestExecutionListener"};
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    static final ContextCache contextCache = new ContextCache();
    private final TestContext testContext;
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();

    public TestContextManager(Class<?> testClass) {
        this(testClass, null);
    }

    @Deprecated
    public TestContextManager(Class<?> testClass, String defaultContextLoaderClassName) {
        this.testContext = new DefaultTestContext(testClass, contextCache, defaultContextLoaderClassName);
        this.registerTestExecutionListeners(this.retrieveTestExecutionListeners(testClass));
    }

    protected final TestContext getTestContext() {
        return this.testContext;
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        for (TestExecutionListener listener : testExecutionListeners) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Registering TestExecutionListener: " + listener));
            }
            this.testExecutionListeners.add(listener);
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    private List<TestExecutionListener> getReversedTestExecutionListeners() {
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        return listenersReversed;
    }

    private TestExecutionListener[] retrieveTestExecutionListeners(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Class<TestExecutionListeners> annotationType = TestExecutionListeners.class;
        ArrayList<Object> classesList = new ArrayList<Object>();
        MetaAnnotationUtils.AnnotationDescriptor<TestExecutionListeners> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(clazz, annotationType);
        if (descriptor == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("@TestExecutionListeners is not present for class [" + clazz.getName() + "]: using defaults."));
            }
            classesList.addAll(this.getDefaultTestExecutionListenerClasses());
        } else {
            while (descriptor != null) {
                Class<?> declaringClass = descriptor.getDeclaringClass();
                AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("Retrieved @TestExecutionListeners attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
                }
                Object[] objectArray = annAttrs.getClassArray("value");
                Object[] listenerClasses = annAttrs.getClassArray("listeners");
                if (!ObjectUtils.isEmpty((Object[])objectArray) && !ObjectUtils.isEmpty((Object[])listenerClasses)) {
                    throw new IllegalStateException(String.format("Class [%s] configured with @TestExecutionListeners' 'value' [%s] and 'listeners' [%s] attributes. Use one or the other, but not both.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])objectArray), ObjectUtils.nullSafeToString((Object[])listenerClasses)));
                }
                if (!ObjectUtils.isEmpty((Object[])objectArray)) {
                    listenerClasses = objectArray;
                }
                if (listenerClasses != null) {
                    classesList.addAll(0, Arrays.asList(listenerClasses));
                }
                descriptor = annAttrs.getBoolean("inheritListeners") ? MetaAnnotationUtils.findAnnotationDescriptor(descriptor.getRootDeclaringClass().getSuperclass(), annotationType) : null;
            }
        }
        ArrayList<Object> listeners = new ArrayList<Object>(classesList.size());
        for (Class clazz2 : classesList) {
            NoClassDefFoundError ncdfe;
            block12: {
                ncdfe = null;
                try {
                    listeners.add(BeanUtils.instantiateClass((Class)clazz2));
                }
                catch (NoClassDefFoundError err) {
                    ncdfe = err;
                }
                catch (BeanInstantiationException ex) {
                    if (!(ex.getCause() instanceof NoClassDefFoundError)) break block12;
                    ncdfe = (NoClassDefFoundError)ex.getCause();
                }
            }
            if (ncdfe == null || !logger.isInfoEnabled()) continue;
            logger.info((Object)String.format("Could not instantiate TestExecutionListener [%s]. Specify custom listener classes or make the default listener classes (and their required dependencies) available. Offending class: [%s]", clazz2.getName(), ncdfe.getMessage()));
        }
        return listeners.toArray(new TestExecutionListener[listeners.size()]);
    }

    @Deprecated
    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        LinkedHashSet<Class<? extends TestExecutionListener>> defaultListenerClasses = new LinkedHashSet<Class<? extends TestExecutionListener>>();
        ClassLoader cl = this.getClass().getClassLoader();
        for (String className : DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES) {
            try {
                defaultListenerClasses.add(ClassUtils.forName((String)className, (ClassLoader)cl));
            }
            catch (Throwable ex) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Could not load default TestExecutionListener class [" + className + "]. Specify custom listener classes or make the default listener classes available."), ex);
            }
        }
        return defaultListenerClasses;
    }

    public void beforeTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestClass(): class [" + testClass.getName() + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before class' callback for test class [" + testClass + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void prepareTestInstance(Object testInstance) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("prepareTestInstance(): instance [" + testInstance + "]"));
        }
        this.getTestContext().updateState(testInstance, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.prepareTestInstance(this.getTestContext());
            }
            catch (Exception ex) {
                logger.error((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to prepare test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        Assert.notNull((Object)testInstance, (String)"Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestMethod(): instance [" + testInstance + "], method [" + testMethod + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before' execution of test method [" + testMethod + "] for test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void afterTestMethod(Object testInstance, Method testMethod, Throwable exception) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestMethod(): instance [" + testInstance + "], method [" + testMethod + "], exception [" + exception + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
        Exception afterTestMethodException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after' execution for test: method [" + testMethod + "], instance [" + testInstance + "], exception [" + exception + "]"), (Throwable)ex);
                if (afterTestMethodException != null) continue;
                afterTestMethodException = ex;
            }
        }
        if (afterTestMethodException != null) {
            throw afterTestMethodException;
        }
    }

    public void afterTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestClass(): class [" + testClass.getName() + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        Exception afterTestClassException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after class' callback for test class [" + testClass + "]"), (Throwable)ex);
                if (afterTestClassException != null) continue;
                afterTestClassException = ex;
            }
        }
        if (afterTestClassException != null) {
            throw afterTestClassException;
        }
    }
}

