/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import org.springframework.mock.web.portlet.MockPortletContext;
import org.springframework.util.Assert;

public class MockPortletConfig
implements PortletConfig {
    private final PortletContext portletContext;
    private final String portletName;
    private final Map resourceBundles = new HashMap();
    private final Properties initParameters = new Properties();

    public MockPortletConfig() {
        this(null, "");
    }

    public MockPortletConfig(String portletName) {
        this(null, portletName);
    }

    public MockPortletConfig(PortletContext portletContext) {
        this(portletContext, "");
    }

    public MockPortletConfig(PortletContext portletContext, String portletName) {
        this.portletContext = portletContext != null ? portletContext : new MockPortletContext();
        this.portletName = portletName;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public void setResourceBundle(Locale locale, ResourceBundle resourceBundle) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        this.resourceBundles.put(locale, resourceBundle);
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null");
        return (ResourceBundle)this.resourceBundles.get(locale);
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        this.initParameters.setProperty(name, value);
    }

    public String getInitParameter(String name) {
        Assert.notNull((Object)name, (String)"Parameter name must not be null");
        return this.initParameters.getProperty(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }
}

