/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import io.r2dbc.spi.Wrapped;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.Ordered;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.r2dbc.BadSqlGrammarException;
import org.springframework.r2dbc.UncategorizedR2dbcException;
import org.springframework.r2dbc.connection.ConnectionHolder;
import org.springframework.r2dbc.connection.DelegatingConnectionFactory;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.reactive.TransactionSynchronization;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class ConnectionFactoryUtils {
    public static final int CONNECTION_SYNCHRONIZATION_ORDER = 1000;
    private static final Set<Integer> DUPLICATE_KEY_ERROR_CODES = Set.of(Integer.valueOf(1), Integer.valueOf(301), Integer.valueOf(1062), Integer.valueOf(2601), Integer.valueOf(2627), Integer.valueOf(-239), Integer.valueOf(-268));

    public static Mono<Connection> getConnection(ConnectionFactory connectionFactory) {
        return ConnectionFactoryUtils.doGetConnection(connectionFactory).onErrorMap(ex -> new DataAccessResourceFailureException("Failed to obtain R2DBC Connection", ex));
    }

    public static Mono<Connection> doGetConnection(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        return TransactionSynchronizationManager.forCurrentTransaction().flatMap(synchronizationManager -> {
            ConnectionHolder conHolder = (ConnectionHolder)((Object)((Object)synchronizationManager.getResource((Object)connectionFactory)));
            if (conHolder != null && (conHolder.hasConnection() || conHolder.isSynchronizedWithTransaction())) {
                conHolder.requested();
                if (!conHolder.hasConnection()) {
                    return ConnectionFactoryUtils.fetchConnection(connectionFactory).doOnNext(conHolder::setConnection);
                }
                return Mono.just((Object)conHolder.getConnection());
            }
            Mono<Connection> con = ConnectionFactoryUtils.fetchConnection(connectionFactory);
            if (synchronizationManager.isSynchronizationActive()) {
                return con.flatMap(connection -> Mono.just((Object)connection).doOnNext(conn -> {
                    ConnectionHolder holderToUse = conHolder;
                    if (holderToUse == null) {
                        holderToUse = new ConnectionHolder((Connection)conn);
                    } else {
                        holderToUse.setConnection((Connection)conn);
                    }
                    holderToUse.requested();
                    synchronizationManager.registerSynchronization((TransactionSynchronization)new ConnectionSynchronization(holderToUse, connectionFactory));
                    holderToUse.setSynchronizedWithTransaction(true);
                    if (holderToUse != conHolder) {
                        synchronizationManager.bindResource((Object)connectionFactory, (Object)holderToUse);
                    }
                }).onErrorResume(ex -> ConnectionFactoryUtils.releaseConnection(connection, connectionFactory).then(Mono.error((Throwable)ex))));
            }
            return con;
        }).onErrorResume(NoTransactionException.class, ex -> Mono.from((Publisher)connectionFactory.create()));
    }

    private static Mono<Connection> fetchConnection(ConnectionFactory connectionFactory) {
        return Mono.from((Publisher)connectionFactory.create());
    }

    public static Mono<Void> releaseConnection(Connection con, ConnectionFactory connectionFactory) {
        return ConnectionFactoryUtils.doReleaseConnection(con, connectionFactory).onErrorMap(ex -> new DataAccessResourceFailureException("Failed to close R2DBC Connection", ex));
    }

    public static Mono<Void> doReleaseConnection(Connection connection, ConnectionFactory connectionFactory) {
        return TransactionSynchronizationManager.forCurrentTransaction().flatMap(synchronizationManager -> {
            ConnectionHolder conHolder = (ConnectionHolder)((Object)((Object)synchronizationManager.getResource((Object)connectionFactory)));
            if (conHolder != null && ConnectionFactoryUtils.connectionEquals(conHolder, connection)) {
                conHolder.released();
                return Mono.empty();
            }
            return Mono.from((Publisher)connection.close());
        }).onErrorResume(NoTransactionException.class, ex -> Mono.from((Publisher)connection.close()));
    }

    public static Mono<ConnectionFactory> currentConnectionFactory(ConnectionFactory connectionFactory) {
        return TransactionSynchronizationManager.forCurrentTransaction().filter(TransactionSynchronizationManager::isSynchronizationActive).filter(synchronizationManager -> {
            ConnectionHolder conHolder = (ConnectionHolder)((Object)((Object)synchronizationManager.getResource((Object)connectionFactory)));
            return conHolder != null && (conHolder.hasConnection() || conHolder.isSynchronizedWithTransaction());
        }).map(synchronizationManager -> connectionFactory);
    }

    public static DataAccessException convertR2dbcException(String task, @Nullable String sql, R2dbcException ex) {
        if (ex instanceof R2dbcTransientException) {
            if (ex instanceof R2dbcTransientResourceException) {
                return new TransientDataAccessResourceException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcRollbackException) {
                if ("40001".equals(ex.getSqlState())) {
                    return new CannotAcquireLockException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
                }
                return new PessimisticLockingFailureException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcTimeoutException) {
                return new QueryTimeoutException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
            }
        } else if (ex instanceof R2dbcNonTransientException) {
            if (ex instanceof R2dbcNonTransientResourceException) {
                return new DataAccessResourceFailureException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcDataIntegrityViolationException) {
                if (ConnectionFactoryUtils.indicatesDuplicateKey(ex.getSqlState(), ex.getErrorCode())) {
                    return new DuplicateKeyException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
                }
                return new DataIntegrityViolationException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcPermissionDeniedException) {
                return new PermissionDeniedDataAccessException(ConnectionFactoryUtils.buildMessage(task, sql, ex), (Throwable)ex);
            }
            if (ex instanceof R2dbcBadGrammarException) {
                return new BadSqlGrammarException(task, sql != null ? sql : "", ex);
            }
        }
        return new UncategorizedR2dbcException(ConnectionFactoryUtils.buildMessage(task, sql, ex), sql, ex);
    }

    static boolean indicatesDuplicateKey(@Nullable String sqlState, int errorCode) {
        return "23505".equals(sqlState) || "23000".equals(sqlState) && DUPLICATE_KEY_ERROR_CODES.contains(errorCode);
    }

    private static String buildMessage(String task, @Nullable String sql, R2dbcException ex) {
        return task + "; " + (String)(sql != null ? "SQL [" + sql + "]; " : "") + ex.getMessage();
    }

    private static boolean connectionEquals(ConnectionHolder conHolder, Connection passedInCon) {
        if (!conHolder.hasConnection()) {
            return false;
        }
        Connection heldCon = conHolder.getConnection();
        return heldCon == passedInCon || heldCon.equals((Object)passedInCon) || ConnectionFactoryUtils.getTargetConnection(heldCon).equals((Object)passedInCon);
    }

    public static Connection getTargetConnection(Connection con) {
        Connection conToUse = con;
        while (conToUse instanceof Wrapped) {
            conToUse = (Connection)((Wrapped)conToUse).unwrap();
        }
        return conToUse;
    }

    private static int getConnectionSynchronizationOrder(ConnectionFactory connectionFactory) {
        int order = 1000;
        ConnectionFactory current = connectionFactory;
        while (current instanceof DelegatingConnectionFactory) {
            DelegatingConnectionFactory delegatingConnectionFactory = (DelegatingConnectionFactory)current;
            --order;
            current = delegatingConnectionFactory.getTargetConnectionFactory();
        }
        return order;
    }

    private static class ConnectionSynchronization
    implements TransactionSynchronization,
    Ordered {
        private final ConnectionHolder connectionHolder;
        private final ConnectionFactory connectionFactory;
        private final int order;
        private boolean holderActive = true;

        ConnectionSynchronization(ConnectionHolder connectionHolder, ConnectionFactory connectionFactory) {
            this.connectionHolder = connectionHolder;
            this.connectionFactory = connectionFactory;
            this.order = ConnectionFactoryUtils.getConnectionSynchronizationOrder(connectionFactory);
        }

        public int getOrder() {
            return this.order;
        }

        public Mono<Void> suspend() {
            if (this.holderActive) {
                return TransactionSynchronizationManager.forCurrentTransaction().flatMap(synchronizationManager -> {
                    synchronizationManager.unbindResource((Object)this.connectionFactory);
                    if (this.connectionHolder.hasConnection() && !this.connectionHolder.isOpen()) {
                        return ConnectionFactoryUtils.releaseConnection(this.connectionHolder.getConnection(), this.connectionFactory).doOnTerminate(() -> this.connectionHolder.setConnection(null));
                    }
                    return Mono.empty();
                });
            }
            return Mono.empty();
        }

        public Mono<Void> resume() {
            if (this.holderActive) {
                return TransactionSynchronizationManager.forCurrentTransaction().doOnNext(synchronizationManager -> synchronizationManager.bindResource((Object)this.connectionFactory, (Object)this.connectionHolder)).then();
            }
            return Mono.empty();
        }

        public Mono<Void> beforeCompletion() {
            if (!this.connectionHolder.isOpen()) {
                return TransactionSynchronizationManager.forCurrentTransaction().flatMap(synchronizationManager -> {
                    synchronizationManager.unbindResource((Object)this.connectionFactory);
                    this.holderActive = false;
                    if (this.connectionHolder.hasConnection()) {
                        return ConnectionFactoryUtils.releaseConnection(this.connectionHolder.getConnection(), this.connectionFactory);
                    }
                    return Mono.empty();
                });
            }
            return Mono.empty();
        }

        public Mono<Void> afterCompletion(int status) {
            if (this.holderActive) {
                return TransactionSynchronizationManager.forCurrentTransaction().flatMap(synchronizationManager -> {
                    synchronizationManager.unbindResourceIfPossible((Object)this.connectionFactory);
                    this.holderActive = false;
                    if (this.connectionHolder.hasConnection()) {
                        return ConnectionFactoryUtils.releaseConnection(this.connectionHolder.getConnection(), this.connectionFactory).doOnTerminate(() -> this.connectionHolder.setConnection(null));
                    }
                    return Mono.empty();
                });
            }
            this.connectionHolder.reset();
            return Mono.empty();
        }
    }
}

