/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.r2dbc.core.ConnectionFunction;
import org.springframework.r2dbc.core.ExecuteFunction;
import org.springframework.r2dbc.core.StatementFilterFunction;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

final class ResultFunction
implements ConnectionFunction<Flux<Result>> {
    final Supplier<String> sqlSupplier;
    final BiFunction<Connection, String, Statement> statementFunction;
    final StatementFilterFunction filterFunction;
    final ExecuteFunction executeFunction;
    @Nullable String resolvedSql = null;

    ResultFunction(Supplier<String> sqlSupplier, BiFunction<Connection, String, Statement> statementFunction, StatementFilterFunction filterFunction, ExecuteFunction executeFunction) {
        this.sqlSupplier = sqlSupplier;
        this.statementFunction = statementFunction;
        this.filterFunction = filterFunction;
        this.executeFunction = executeFunction;
    }

    @Override
    public Flux<Result> apply(Connection connection) {
        String sql = this.sqlSupplier.get();
        Assert.state((boolean)StringUtils.hasText((String)sql), (String)"SQL returned by supplier must not be empty");
        this.resolvedSql = sql;
        Statement statement = this.statementFunction.apply(connection, sql);
        return Flux.from(this.filterFunction.filter(statement, this.executeFunction)).cast(Result.class).checkpoint("SQL \"" + sql + "\" [DatabaseClient]");
    }

    @Override
    public @Nullable String getSql() {
        return this.resolvedSql;
    }
}

