/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import io.r2dbc.spi.Statement;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.r2dbc.core.ConnectionAccessor;
import org.springframework.r2dbc.core.DefaultDatabaseClientBuilder;
import org.springframework.r2dbc.core.ExecuteFunction;
import org.springframework.r2dbc.core.FetchSpec;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.r2dbc.core.StatementFilterFunction;
import org.springframework.r2dbc.core.binding.BindMarkersFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DatabaseClient
extends ConnectionAccessor {
    public ConnectionFactory getConnectionFactory();

    public GenericExecuteSpec sql(String var1);

    public GenericExecuteSpec sql(Supplier<String> var1);

    public static DatabaseClient create(ConnectionFactory factory) {
        return new DefaultDatabaseClientBuilder().connectionFactory(factory).build();
    }

    public static Builder builder() {
        return new DefaultDatabaseClientBuilder();
    }

    public static interface Builder {
        public Builder bindMarkers(BindMarkersFactory var1);

        public Builder connectionFactory(ConnectionFactory var1);

        public Builder executeFunction(ExecuteFunction var1);

        public Builder namedParameters(boolean var1);

        public Builder apply(Consumer<Builder> var1);

        public DatabaseClient build();
    }

    public static interface GenericExecuteSpec {
        public GenericExecuteSpec bind(int var1, Object var2);

        public GenericExecuteSpec bindNull(int var1, Class<?> var2);

        public GenericExecuteSpec bind(String var1, Object var2);

        public GenericExecuteSpec bindNull(String var1, Class<?> var2);

        public GenericExecuteSpec bindValues(Map<String, ?> var1);

        public GenericExecuteSpec bindProperties(Object var1);

        default public GenericExecuteSpec filter(Function<? super Statement, ? extends Statement> filterFunction) {
            Assert.notNull(filterFunction, (String)"Filter function must not be null");
            return this.filter((Statement statement, ExecuteFunction next) -> next.execute((Statement)filterFunction.apply(statement)));
        }

        public GenericExecuteSpec filter(StatementFilterFunction var1);

        public <R> RowsFetchSpec<R> map(Function<? super Readable, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public <R> RowsFetchSpec<R> mapValue(Class<R> var1);

        public <R> RowsFetchSpec<R> mapProperties(Class<R> var1);

        public <R> Flux<R> flatMap(Function<Result, Publisher<R>> var1);

        public FetchSpec<Map<String, Object>> fetch();

        public Mono<Void> then();
    }
}

