/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.hibernate;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.jpa.hibernate.SpringSessionContext;

public abstract class SharedSessionCreator {
    public static Session createSharedSession(SessionFactory sessionFactory) {
        return (Session)Proxy.newProxyInstance(SharedSessionCreator.class.getClassLoader(), new Class[]{Session.class}, (InvocationHandler)new SharedSessionInvocationHandler(sessionFactory, () -> ((SessionFactory)sessionFactory).getCurrentSession()));
    }

    public static StatelessSession createSharedStatelessSession(SessionFactory sessionFactory) {
        return (StatelessSession)Proxy.newProxyInstance(SharedSessionCreator.class.getClassLoader(), new Class[]{StatelessSession.class}, (InvocationHandler)new SharedSessionInvocationHandler(sessionFactory, () -> SpringSessionContext.currentStatelessSession(sessionFactory)));
    }

    private static class SharedSessionInvocationHandler
    implements InvocationHandler {
        private final SessionFactory sessionFactory;
        private final Supplier<Object> currentSessionSupplier;

        public SharedSessionInvocationHandler(SessionFactory sessionFactory, Supplier<Object> currentSessionSupplier) {
            this.sessionFactory = sessionFactory;
            this.currentSessionSupplier = currentSessionSupplier;
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return this.hashCode();
                }
                case "toString": {
                    return "Shared Session proxy for target factory [" + String.valueOf(this.sessionFactory) + "]";
                }
                case "getSessionFactory": 
                case "getEntityManagerFactory": {
                    return this.sessionFactory;
                }
                case "getCriteriaBuilder": 
                case "getMetamodel": {
                    try {
                        return SessionFactory.class.getMethod(method.getName(), new Class[0]).invoke((Object)this.sessionFactory, new Object[0]);
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
                case "unwrap": {
                    Class targetClass = (Class)args[0];
                    if (targetClass == null || !targetClass.isInstance(proxy)) break;
                    return proxy;
                }
                case "isOpen": {
                    return true;
                }
                case "close": {
                    return null;
                }
                case "getTransaction": {
                    throw new IllegalStateException("Not allowed to create transaction on shared EntityManager - use Spring transactions or EJB CMT instead");
                }
            }
            Object target = this.currentSessionSupplier.get();
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

