/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.core;

import jakarta.jms.ConnectionFactory;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.core.DefaultJmsClient;
import org.springframework.jms.core.JmsClient;
import org.springframework.jms.core.JmsOperations;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.CompositeMessagePostProcessor;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.util.Assert;

class DefaultJmsClientBuilder
implements JmsClient.Builder {
    private final DefaultJmsClient jmsClient;
    private @Nullable List<MessageConverter> messageConverters;
    private @Nullable List<MessagePostProcessor> messagePostProcessors;

    DefaultJmsClientBuilder(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        this.jmsClient = new DefaultJmsClient(connectionFactory);
    }

    DefaultJmsClientBuilder(JmsOperations jmsTemplate) {
        Assert.notNull((Object)jmsTemplate, (String)"JmsOperations must not be null");
        this.jmsClient = new DefaultJmsClient(jmsTemplate);
    }

    @Override
    public JmsClient.Builder messageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"MessageConverter must not be null");
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList<MessageConverter>();
        }
        this.messageConverters.add(messageConverter);
        return this;
    }

    @Override
    public JmsClient.Builder messagePostProcessor(MessagePostProcessor messagePostProcessor) {
        Assert.notNull((Object)messagePostProcessor, (String)"MessagePostProcessor must not be null");
        if (this.messagePostProcessors == null) {
            this.messagePostProcessors = new ArrayList<MessagePostProcessor>();
        }
        this.messagePostProcessors.add(messagePostProcessor);
        return this;
    }

    @Override
    public JmsClient build() {
        if (this.messageConverters != null) {
            this.jmsClient.setMessageConverter((MessageConverter)new CompositeMessageConverter(this.messageConverters));
        }
        if (this.messagePostProcessors != null) {
            this.jmsClient.setMessagePostProcessor((MessagePostProcessor)new CompositeMessagePostProcessor(this.messagePostProcessors));
        }
        return this.jmsClient;
    }
}

