/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicSession;
import jakarta.jms.TransactionInProgressException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.connection.SessionProxy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TransactionAwareConnectionFactoryProxy
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private @Nullable ConnectionFactory targetConnectionFactory;
    private boolean synchedLocalTransactionAllowed = false;

    public TransactionAwareConnectionFactoryProxy() {
    }

    public TransactionAwareConnectionFactoryProxy(ConnectionFactory targetConnectionFactory) {
        this.setTargetConnectionFactory(targetConnectionFactory);
    }

    public final void setTargetConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull((Object)targetConnectionFactory, (String)"'targetConnectionFactory' must not be null");
        this.targetConnectionFactory = targetConnectionFactory;
    }

    protected ConnectionFactory getTargetConnectionFactory() {
        ConnectionFactory target = this.targetConnectionFactory;
        Assert.state((target != null ? 1 : 0) != 0, (String)"'targetConnectionFactory' is required");
        return target;
    }

    public void setSynchedLocalTransactionAllowed(boolean synchedLocalTransactionAllowed) {
        this.synchedLocalTransactionAllowed = synchedLocalTransactionAllowed;
    }

    protected boolean isSynchedLocalTransactionAllowed() {
        return this.synchedLocalTransactionAllowed;
    }

    public Connection createConnection() throws JMSException {
        Connection targetConnection = this.getTargetConnectionFactory().createConnection();
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        Connection targetConnection = this.getTargetConnectionFactory().createConnection(username, password);
        return this.getTransactionAwareConnectionProxy(targetConnection);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)target;
        QueueConnection targetConnection = queueFactory.createQueueConnection();
        return (QueueConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof QueueConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no QueueConnectionFactory");
        }
        QueueConnectionFactory queueFactory = (QueueConnectionFactory)target;
        QueueConnection targetConnection = queueFactory.createQueueConnection(username, password);
        return (QueueConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnectionFactory topicFactory = (TopicConnectionFactory)target;
        TopicConnection targetConnection = topicFactory.createTopicConnection();
        return (TopicConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        ConnectionFactory target = this.getTargetConnectionFactory();
        if (!(target instanceof TopicConnectionFactory)) {
            throw new IllegalStateException("'targetConnectionFactory' is no TopicConnectionFactory");
        }
        TopicConnectionFactory topicFactory = (TopicConnectionFactory)target;
        TopicConnection targetConnection = topicFactory.createTopicConnection(username, password);
        return (TopicConnection)this.getTransactionAwareConnectionProxy((Connection)targetConnection);
    }

    public JMSContext createContext() {
        return this.getTargetConnectionFactory().createContext();
    }

    public JMSContext createContext(String userName, String password) {
        return this.getTargetConnectionFactory().createContext(userName, password);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        return this.getTargetConnectionFactory().createContext(userName, password, sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return this.getTargetConnectionFactory().createContext(sessionMode);
    }

    protected Connection getTransactionAwareConnectionProxy(Connection target) {
        ArrayList<Class<TopicConnection>> classes = new ArrayList<Class<TopicConnection>>(3);
        classes.add(Connection.class);
        if (target instanceof QueueConnection) {
            classes.add(QueueConnection.class);
        }
        if (target instanceof TopicConnection) {
            classes.add(TopicConnection.class);
        }
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), ClassUtils.toClassArray(classes), (InvocationHandler)new TransactionAwareConnectionInvocationHandler(target));
    }

    private class TransactionAwareConnectionInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public TransactionAwareConnectionInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Session session;
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
            }
            if (Session.class == method.getReturnType() ? (session = ConnectionFactoryUtils.getTransactionalSession(TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null : (QueueSession.class == method.getReturnType() ? (session = ConnectionFactoryUtils.getTransactionalQueueSession((QueueConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (QueueConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null : TopicSession.class == method.getReturnType() && (session = ConnectionFactoryUtils.getTransactionalTopicSession((TopicConnectionFactory)TransactionAwareConnectionFactoryProxy.this.getTargetConnectionFactory(), (TopicConnection)this.target, TransactionAwareConnectionFactoryProxy.this.isSynchedLocalTransactionAllowed())) != null)) {
                return this.getCloseSuppressingSessionProxy(session);
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private Session getCloseSuppressingSessionProxy(Session target) {
            ArrayList<Class<TopicSession>> classes = new ArrayList<Class<TopicSession>>(3);
            classes.add(SessionProxy.class);
            if (target instanceof QueueSession) {
                classes.add(QueueSession.class);
            }
            if (target instanceof TopicSession) {
                classes.add(TopicSession.class);
            }
            return (Session)Proxy.newProxyInstance(SessionProxy.class.getClassLoader(), ClassUtils.toClassArray(classes), (InvocationHandler)new CloseSuppressingSessionInvocationHandler(target));
        }
    }

    private static class CloseSuppressingSessionInvocationHandler
    implements InvocationHandler {
        private final Session target;

        public CloseSuppressingSessionInvocationHandler(Session target) {
            this.target = target;
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object object;
            switch (method.getName()) {
                case "equals": {
                    Boolean bl = proxy == args[0];
                    object = bl;
                    break;
                }
                case "hashCode": {
                    Integer n = System.identityHashCode(proxy);
                    object = n;
                    break;
                }
                case "commit": {
                    throw new TransactionInProgressException("Commit call not allowed within a managed transaction");
                }
                case "rollback": {
                    throw new TransactionInProgressException("Rollback call not allowed within a managed transaction");
                }
                case "close": {
                    Session session;
                    object = session = null;
                    break;
                }
                case "getTargetSession": {
                    Session session;
                    object = session = this.target;
                    break;
                }
                default: {
                    try {
                        Object object2 = method.invoke((Object)this.target, args);
                        object = object2;
                        break;
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                }
            }
            return object;
        }
    }
}

