/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;
import org.jspecify.annotations.Nullable;
import org.springframework.util.FileCopyUtils;

@Deprecated
class PassThroughClob
implements Clob {
    private @Nullable String content;
    private @Nullable Reader characterStream;
    private @Nullable InputStream asciiStream;
    private final long contentLength;

    public PassThroughClob(String content) {
        this.content = content;
        this.contentLength = content.length();
    }

    public PassThroughClob(Reader characterStream, long contentLength) {
        this.characterStream = characterStream;
        this.contentLength = contentLength;
    }

    public PassThroughClob(InputStream asciiStream, long contentLength) {
        this.asciiStream = asciiStream;
        this.contentLength = contentLength;
    }

    @Override
    public long length() throws SQLException {
        return this.contentLength;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.content != null) {
            return new StringReader(this.content);
        }
        if (this.characterStream != null) {
            return this.characterStream;
        }
        return new InputStreamReader(this.asciiStream != null ? this.asciiStream : InputStream.nullInputStream(), StandardCharsets.US_ASCII);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            if (this.content != null) {
                return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.US_ASCII));
            }
            if (this.characterStream != null) {
                String tempContent = FileCopyUtils.copyToString((Reader)this.characterStream);
                return new ByteArrayInputStream(tempContent.getBytes(StandardCharsets.US_ASCII));
            }
            return this.asciiStream != null ? this.asciiStream : InputStream.nullInputStream();
        }
        catch (IOException ex) {
            throw new SQLException("Failed to read stream content: " + String.valueOf(ex));
        }
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
    }
}

