/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.lookup;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;

public class MapDataSourceLookup
implements DataSourceLookup {
    private final Map dataSources = new HashMap(16);

    public MapDataSourceLookup() {
    }

    public MapDataSourceLookup(Map dataSources) {
        this.setDataSources(dataSources);
    }

    public void addDataSource(String dataSourceName, DataSource dataSource) {
        this.dataSources.put(dataSourceName, dataSource);
    }

    public void setDataSources(Map dataSources) {
        if (dataSources != null) {
            this.dataSources.putAll(dataSources);
        }
    }

    public Map getDataSources() {
        return Collections.unmodifiableMap(this.dataSources);
    }

    public DataSource getDataSource(String dataSourceName) throws DataAccessResourceFailureException {
        DataSource dataSource;
        try {
            dataSource = (DataSource)this.dataSources.get(dataSourceName);
        }
        catch (ClassCastException ex) {
            throw new DataAccessResourceFailureException("The object in the DataSource map with this name '" + dataSourceName + "' is not a DataSource", (Throwable)ex);
        }
        if (dataSource == null) {
            throw new DataAccessResourceFailureException("No DataSource with name '" + dataSourceName + "' registered");
        }
        return dataSource;
    }
}

