/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.aot;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;

class ApplicationContextInitializationCodeGenerator
implements BeanFactoryInitializationCode {
    private static final String INITIALIZE_METHOD = "initialize";
    private static final String APPLICATION_CONTEXT_VARIABLE = "applicationContext";
    private final GenericApplicationContext applicationContext;
    private final GeneratedClass generatedClass;
    private final List<MethodReference> initializers = new ArrayList<MethodReference>();

    ApplicationContextInitializationCodeGenerator(GenericApplicationContext applicationContext, GenerationContext generationContext) {
        this.applicationContext = applicationContext;
        this.generatedClass = generationContext.getGeneratedClasses().addForFeature("ApplicationContextInitializer", this::generateType);
        this.generatedClass.reserveMethodNames(new String[]{INITIALIZE_METHOD});
    }

    private void generateType(TypeSpec.Builder type) {
        type.addJavadoc("{@link $T} to restore an application context based on previous AOT processing.", new Object[]{ApplicationContextInitializer.class});
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addSuperinterface((TypeName)ParameterizedTypeName.get(ApplicationContextInitializer.class, (Type[])new Type[]{GenericApplicationContext.class}));
        type.addMethod(this.generateInitializeMethod());
    }

    private MethodSpec generateInitializeMethod() {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)INITIALIZE_METHOD);
        method.addAnnotation(Override.class);
        method.addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addParameter(GenericApplicationContext.class, APPLICATION_CONTEXT_VARIABLE, new Modifier[0]);
        method.addCode(this.generateInitializeCode());
        return method.build();
    }

    private CodeBlock generateInitializeCode() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T $L = $L.getDefaultListableBeanFactory()", new Object[]{DefaultListableBeanFactory.class, "beanFactory", APPLICATION_CONTEXT_VARIABLE});
        code.addStatement("$L.setAutowireCandidateResolver(new $T())", new Object[]{"beanFactory", ContextAnnotationAutowireCandidateResolver.class});
        code.addStatement("$L.setDependencyComparator($T.INSTANCE)", new Object[]{"beanFactory", AnnotationAwareOrderComparator.class});
        code.add(this.generateActiveProfilesInitializeCode());
        MethodReference.ArgumentCodeGenerator argCodeGenerator = ApplicationContextInitializationCodeGenerator.createInitializerMethodArgumentCodeGenerator();
        for (MethodReference initializer : this.initializers) {
            code.addStatement(initializer.toInvokeCodeBlock(argCodeGenerator, this.generatedClass.getName()));
        }
        return code.build();
    }

    private CodeBlock generateActiveProfilesInitializeCode() {
        CodeBlock.Builder code = CodeBlock.builder();
        ConfigurableEnvironment environment2 = this.applicationContext.getEnvironment();
        if (!Arrays.equals(environment2.getActiveProfiles(), environment2.getDefaultProfiles())) {
            for (String activeProfile : environment2.getActiveProfiles()) {
                code.addStatement("$L.getEnvironment().addActiveProfile($S)", new Object[]{APPLICATION_CONTEXT_VARIABLE, activeProfile});
            }
        }
        return code.build();
    }

    static MethodReference.ArgumentCodeGenerator createInitializerMethodArgumentCodeGenerator() {
        return MethodReference.ArgumentCodeGenerator.from((Function)new InitializerMethodArgumentCodeGenerator());
    }

    GeneratedClass getGeneratedClass() {
        return this.generatedClass;
    }

    public GeneratedMethods getMethods() {
        return this.generatedClass.getMethods();
    }

    public void addInitializer(MethodReference methodReference) {
        this.initializers.add(methodReference);
    }

    private static class InitializerMethodArgumentCodeGenerator
    implements Function<TypeName, CodeBlock> {
        private InitializerMethodArgumentCodeGenerator() {
        }

        @Override
        public @Nullable CodeBlock apply(TypeName typeName) {
            CodeBlock codeBlock;
            if (typeName instanceof ClassName) {
                ClassName className = (ClassName)typeName;
                codeBlock = this.apply(className);
            } else {
                codeBlock = null;
            }
            return codeBlock;
        }

        @Override
        private @Nullable CodeBlock apply(ClassName className) {
            String name = className.canonicalName();
            if (name.equals(DefaultListableBeanFactory.class.getName()) || name.equals(ListableBeanFactory.class.getName()) || name.equals(ConfigurableListableBeanFactory.class.getName())) {
                return CodeBlock.of((String)"beanFactory", (Object[])new Object[0]);
            }
            if (name.equals(ConfigurableEnvironment.class.getName()) || name.equals(Environment.class.getName())) {
                return CodeBlock.of((String)"$L.getEnvironment()", (Object[])new Object[]{ApplicationContextInitializationCodeGenerator.APPLICATION_CONTEXT_VARIABLE});
            }
            if (name.equals(ResourceLoader.class.getName())) {
                return CodeBlock.of((String)ApplicationContextInitializationCodeGenerator.APPLICATION_CONTEXT_VARIABLE, (Object[])new Object[0]);
            }
            return null;
        }
    }
}

