/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.standard;

import java.text.ParseException;
import java.time.Duration;
import java.util.Locale;
import org.jspecify.annotations.Nullable;
import org.springframework.format.Formatter;
import org.springframework.format.annotation.DurationFormat;
import org.springframework.format.datetime.standard.DurationFormatterUtils;

public class DurationFormatter
implements Formatter<Duration> {
    private final DurationFormat.Style style;
    private final  @Nullable DurationFormat.Unit defaultUnit;

    DurationFormatter() {
        this(DurationFormat.Style.ISO8601);
    }

    public DurationFormatter(DurationFormat.Style style) {
        this(style, null);
    }

    public DurationFormatter(DurationFormat.Style style,  @Nullable DurationFormat.Unit defaultUnit) {
        this.style = style;
        this.defaultUnit = defaultUnit;
    }

    @Override
    public Duration parse(String text, Locale locale) throws ParseException {
        if (this.defaultUnit == null) {
            return DurationFormatterUtils.parse(text, this.style);
        }
        return DurationFormatterUtils.parse(text, this.style, this.defaultUnit);
    }

    @Override
    public String print(Duration object, Locale locale) {
        if (this.defaultUnit == null) {
            return DurationFormatterUtils.print(object, this.style);
        }
        return DurationFormatterUtils.print(object, this.style, this.defaultUnit);
    }
}

