/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.jruby;

import java.io.IOException;
import org.jruby.exceptions.JumpException;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.jruby.JRubyScriptUtils;
import org.springframework.util.Assert;

public class JRubyScriptFactory
implements ScriptFactory {
    private final String scriptSourceLocator;
    private final Class[] scriptInterfaces;

    public JRubyScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText((String)scriptSourceLocator);
        Assert.notEmpty((Object[])scriptInterfaces);
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    public Object getScriptedObject(ScriptSource actualScriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            return JRubyScriptUtils.createJRubyObject(actualScriptSource.getScriptAsString(), actualInterfaces);
        }
        catch (JumpException ex) {
            throw new ScriptCompilationException("Could not compile JRuby script: " + actualScriptSource, ex);
        }
    }
}

