/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.DisposableBeanAdapter;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractBeanFactory
extends DefaultSingletonBeanRegistry
implements ConfigurableBeanFactory {
    private BeanFactory parentBeanFactory;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean cacheBeanMetadata = true;
    private final Map customEditors = new HashMap();
    private final Set propertyEditorRegistrars = CollectionFactory.createLinkedSetIfPossible((int)16);
    private final List beanPostProcessors = new ArrayList();
    private boolean hasDestructionAwareBeanPostProcessors;
    private final Map aliasMap = new HashMap();
    private final Map mergedBeanDefinitions = new HashMap();
    private final Map scopes = new HashMap();
    private final Set alreadyCreated = Collections.synchronizedSet(new HashSet());
    private final ThreadLocal prototypesCurrentlyInCreation = new ThreadLocal();
    private final Map factoryBeanObjectCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanCurrentlyInCreationException;
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBeanNotInitializedException;
    static /* synthetic */ Class array$Ljava$lang$String;

    public AbstractBeanFactory() {
    }

    public AbstractBeanFactory(BeanFactory parentBeanFactory) {
        this.setParentBeanFactory(parentBeanFactory);
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, null, null);
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        return this.getBean(name, requiredType, null);
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        return this.getBean(name, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean(String name, Class requiredType, final Object[] args) throws BeansException {
        final String beanName = this.transformedBeanName(name);
        Object bean = null;
        Object sharedInstance = this.getSingleton(beanName);
        if (sharedInstance != null) {
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning eagerly cached instance of singleton bean '" + beanName + "' that is not fully initialized yet - a consequence of a circular reference"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning cached instance of singleton bean '" + beanName + "'"));
            }
            if (this.containsBeanDefinition(beanName)) {
                RootBeanDefinition mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
                bean = this.getObjectForBeanInstance(sharedInstance, name, mergedBeanDefinition);
            } else {
                bean = this.getObjectForBeanInstance(sharedInstance, name, null);
            }
        } else {
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                throw new BeanCurrentlyInCreationException(beanName);
            }
            if (this.getParentBeanFactory() != null && !this.containsBeanDefinition(beanName)) {
                if (this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                    return ((AbstractBeanFactory)this.getParentBeanFactory()).getBean(name, requiredType, args);
                }
                if (args == null) {
                    return this.getParentBeanFactory().getBean(name, requiredType);
                }
                throw new NoSuchBeanDefinitionException(beanName, "Cannot delegate to parent BeanFactory because it does not supported passed-in arguments");
            }
            this.alreadyCreated.add(beanName);
            final RootBeanDefinition mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
            this.checkMergedBeanDefinition(mergedBeanDefinition, beanName, args);
            if (mergedBeanDefinition.isSingleton()) {
                sharedInstance = this.getSingleton(beanName, new ObjectFactory(){

                    public Object getObject() throws BeansException {
                        try {
                            return AbstractBeanFactory.this.createBean(beanName, mergedBeanDefinition, args);
                        }
                        catch (BeansException ex) {
                            AbstractBeanFactory.this.destroySingleton(beanName);
                            throw ex;
                        }
                    }
                });
                bean = this.getObjectForBeanInstance(sharedInstance, name, mergedBeanDefinition);
            } else if (mergedBeanDefinition.isPrototype()) {
                Object prototypeInstance = null;
                try {
                    this.beforePrototypeCreation(beanName);
                    prototypeInstance = this.createBean(beanName, mergedBeanDefinition, args);
                }
                finally {
                    this.afterPrototypeCreation(beanName);
                }
                bean = this.getObjectForBeanInstance(prototypeInstance, name, mergedBeanDefinition);
            } else {
                String scopeName = mergedBeanDefinition.getScope();
                Scope scope = (Scope)this.scopes.get(scopeName);
                if (scope == null) {
                    throw new IllegalStateException("No Scope registered for scope '" + scopeName + "'");
                }
                try {
                    Object scopedInstance = scope.get(beanName, new ObjectFactory(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object getObject() throws BeansException {
                            AbstractBeanFactory.this.beforePrototypeCreation(beanName);
                            try {
                                Object object = AbstractBeanFactory.this.createBean(beanName, mergedBeanDefinition, args);
                                return object;
                            }
                            finally {
                                AbstractBeanFactory.this.afterPrototypeCreation(beanName);
                            }
                        }
                    });
                    bean = this.getObjectForBeanInstance(scopedInstance, name, mergedBeanDefinition);
                }
                catch (IllegalStateException ex) {
                    throw new BeanCreationException(beanName, "Scope '" + scopeName + "' is not active", ex);
                }
            }
        }
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public boolean containsBean(String name) {
        if (this.containsLocalBean(name)) {
            return true;
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null) {
            return parentBeanFactory.containsBean(name);
        }
        return false;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Class beanClass = null;
        boolean singleton = true;
        Object beanInstance = this.getSingleton(beanName);
        if (beanInstance != null) {
            beanClass = beanInstance.getClass();
            singleton = true;
        } else {
            if (this.getParentBeanFactory() != null && !this.containsBeanDefinition(beanName)) {
                return this.getParentBeanFactory().isSingleton(name);
            }
            RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
            beanClass = this.resolveBeanClass(bd, beanName);
            singleton = bd.isSingleton();
        }
        if (singleton && beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !BeanFactoryUtils.isFactoryDereference(name)) {
            FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
            return factoryBean.isSingleton();
        }
        return singleton;
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        try {
            Class beanClass = null;
            Object beanInstance = this.getSingleton(beanName);
            if (beanInstance != null) {
                beanClass = beanInstance.getClass();
            } else {
                if (this.getParentBeanFactory() != null && !this.containsBeanDefinition(beanName)) {
                    return this.getParentBeanFactory().getType(name);
                }
                RootBeanDefinition mergedBeanDefinition = this.getMergedBeanDefinition(beanName, false);
                if (mergedBeanDefinition.getFactoryMethodName() != null) {
                    return this.getTypeForFactoryMethod(name, mergedBeanDefinition);
                }
                beanClass = this.resolveBeanClass(mergedBeanDefinition, beanName);
            }
            if (beanClass != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(beanClass) && !BeanFactoryUtils.isFactoryDereference(name)) {
                FactoryBean factoryBean = (FactoryBean)this.getBean("&" + beanName);
                return factoryBean.getObjectType();
            }
            return beanClass;
        }
        catch (BeanCreationException ex) {
            if (ex.contains(class$org$springframework$beans$factory$BeanCurrentlyInCreationException == null ? (class$org$springframework$beans$factory$BeanCurrentlyInCreationException = AbstractBeanFactory.class$("org.springframework.beans.factory.BeanCurrentlyInCreationException")) : class$org$springframework$beans$factory$BeanCurrentlyInCreationException) || ex.contains(class$org$springframework$beans$factory$FactoryBeanNotInitializedException == null ? (class$org$springframework$beans$factory$FactoryBeanNotInitializedException = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBeanNotInitializedException")) : class$org$springframework$beans$factory$FactoryBeanNotInitializedException)) {
                this.logger.debug((Object)"Ignoring BeanCreationException on FactoryBean type check", (Throwable)((Object)ex));
                return null;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        if (this.containsSingleton(beanName) || this.containsBeanDefinition(beanName)) {
            ArrayList aliases = new ArrayList();
            Map map = this.aliasMap;
            synchronized (map) {
                Iterator it = this.aliasMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!entry.getValue().equals(beanName)) continue;
                    aliases.add(entry.getKey());
                }
            }
            return StringUtils.toStringArray(aliases);
        }
        BeanFactory parentBeanFactory = this.getParentBeanFactory();
        if (parentBeanFactory != null) {
            return parentBeanFactory.getAliases(name);
        }
        throw new NoSuchBeanDefinitionException(beanName, this.toString());
    }

    public BeanFactory getParentBeanFactory() {
        return this.parentBeanFactory;
    }

    public boolean containsLocalBean(String name) {
        String beanName = this.transformedBeanName(name);
        return this.containsSingleton(beanName) || this.containsBeanDefinition(beanName);
    }

    public void setParentBeanFactory(BeanFactory parentBeanFactory) {
        this.parentBeanFactory = parentBeanFactory;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader != null ? beanClassLoader : ClassUtils.getDefaultClassLoader();
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setCacheBeanMetadata(boolean cacheBeanMetadata) {
        this.cacheBeanMetadata = cacheBeanMetadata;
    }

    public boolean isCacheBeanMetadata() {
        return this.cacheBeanMetadata;
    }

    public void addPropertyEditorRegistrar(PropertyEditorRegistrar registrar) {
        Assert.notNull((Object)registrar, (String)"PropertyEditorRegistrar must not be null");
        this.propertyEditorRegistrars.add(registrar);
    }

    public Set getPropertyEditorRegistrars() {
        return this.propertyEditorRegistrars;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        Assert.notNull((Object)requiredType, (String)"Required type must not be null");
        Assert.notNull((Object)propertyEditor, (String)"PropertyEditor must not be null");
        this.customEditors.put(requiredType, propertyEditor);
    }

    public Map getCustomEditors() {
        return this.customEditors;
    }

    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        Assert.notNull((Object)beanPostProcessor, (String)"BeanPostProcessor must not be null");
        this.beanPostProcessors.add(beanPostProcessor);
        if (beanPostProcessor instanceof DestructionAwareBeanPostProcessor) {
            this.hasDestructionAwareBeanPostProcessors = true;
        }
    }

    public int getBeanPostProcessorCount() {
        return this.beanPostProcessors.size();
    }

    public List getBeanPostProcessors() {
        return this.beanPostProcessors;
    }

    protected boolean hasDestructionAwareBeanPostProcessors() {
        return this.hasDestructionAwareBeanPostProcessors;
    }

    private void beforePrototypeCreation(String beanName) {
        HashSet<String> beanNames = (HashSet<String>)this.prototypesCurrentlyInCreation.get();
        if (beanNames == null) {
            beanNames = new HashSet<String>();
            this.prototypesCurrentlyInCreation.set(beanNames);
        }
        beanNames.add(beanName);
    }

    private void afterPrototypeCreation(String beanName) {
        Set beanNames = (Set)this.prototypesCurrentlyInCreation.get();
        if (beanNames != null) {
            beanNames.remove(beanName);
            if (beanNames.isEmpty()) {
                this.prototypesCurrentlyInCreation.set(null);
            }
        }
    }

    protected final boolean isPrototypeCurrentlyInCreation(String beanName) {
        Set beanNames = (Set)this.prototypesCurrentlyInCreation.get();
        if (beanNames != null) {
            return beanNames.contains(beanName);
        }
        return false;
    }

    public boolean isCurrentlyInCreation(String beanName) {
        return this.isSingletonCurrentlyInCreation(beanName) || this.isPrototypeCurrentlyInCreation(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        Assert.hasText((String)beanName, (String)"Bean name must not be empty");
        Assert.hasText((String)alias, (String)"Alias must not be empty");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering alias '" + alias + "' for bean with name '" + beanName + "'"));
        }
        Map map = this.aliasMap;
        synchronized (map) {
            Object registeredName = this.aliasMap.get(alias);
            if (registeredName != null) {
                throw new BeanDefinitionStoreException("Cannot register alias '" + alias + "' for bean name '" + beanName + "': it's already registered for bean name '" + registeredName + "'");
            }
            this.aliasMap.put(alias, beanName);
        }
    }

    public void registerScope(String scopeName, Scope scope) {
        Assert.notNull((Object)scopeName, (String)"Scope identifier must not be null");
        Assert.notNull((Object)scope, (String)"Scope must not be null");
        this.scopes.put(scopeName, scope);
    }

    public void destroyScopedBean(String beanName) {
        RootBeanDefinition mergedBeanDefinition = this.getMergedBeanDefinition(beanName);
        if (mergedBeanDefinition.isSingleton() || mergedBeanDefinition.isPrototype()) {
            throw new IllegalArgumentException("Bean name '" + beanName + "' does not correspond to an object in a Scope");
        }
        String scopeName = mergedBeanDefinition.getScope();
        Scope scope = (Scope)this.scopes.get(scopeName);
        if (scope == null) {
            throw new IllegalStateException("No Scope registered for scope '" + scopeName + "'");
        }
        Object bean = scope.remove(beanName);
        if (bean != null) {
            try {
                new DisposableBeanAdapter(bean, beanName, mergedBeanDefinition, this.getBeanPostProcessors()).destroy();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Destroy method on bean with name '" + beanName + "' threw an exception"), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String transformedBeanName(String name) {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Map map = this.aliasMap;
        synchronized (map) {
            String canonicalName = (String)this.aliasMap.get(beanName);
            return canonicalName != null ? canonicalName : beanName;
        }
    }

    protected void initBeanWrapper(BeanWrapper bw) {
        bw.registerCustomEditor(array$Ljava$lang$String == null ? (array$Ljava$lang$String = AbstractBeanFactory.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, new StringArrayPropertyEditor());
        Iterator<Object> it = this.getPropertyEditorRegistrars().iterator();
        while (it.hasNext()) {
            PropertyEditorRegistrar registrar = (PropertyEditorRegistrar)it.next();
            registrar.registerCustomEditors(bw);
        }
        it = this.getCustomEditors().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Class clazz = (Class)entry.getKey();
            PropertyEditor editor = (PropertyEditor)entry.getValue();
            bw.registerCustomEditor(clazz, editor);
        }
    }

    protected Object doTypeConversionIfNecessary(Object value, Class targetType) throws TypeMismatchException {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.initBeanWrapper(bw);
        return this.doTypeConversionIfNecessary(bw, value, targetType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doTypeConversionIfNecessary(BeanWrapperImpl bw, Object value, Class targetType, MethodParameter methodParam) throws TypeMismatchException {
        if (!this.getCustomEditors().isEmpty()) {
            Map map = this.getCustomEditors();
            synchronized (map) {
                return bw.doTypeConversionIfNecessary(value, targetType, methodParam);
            }
        }
        return bw.doTypeConversionIfNecessary(value, targetType, methodParam);
    }

    public RootBeanDefinition getMergedBeanDefinition(String name) throws BeansException {
        return this.getMergedBeanDefinition(name, false);
    }

    protected RootBeanDefinition getMergedBeanDefinition(String name, boolean includingAncestors) throws BeansException {
        String beanName = this.transformedBeanName(name);
        if (includingAncestors && !this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).getMergedBeanDefinition(beanName, true);
        }
        return this.getMergedBeanDefinition(beanName, this.getBeanDefinition(beanName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd) throws BeanDefinitionStoreException {
        Map map = this.mergedBeanDefinitions;
        synchronized (map) {
            RootBeanDefinition mbd = (RootBeanDefinition)this.mergedBeanDefinitions.get(bd);
            if (mbd == null) {
                if (bd instanceof RootBeanDefinition) {
                    mbd = new RootBeanDefinition((RootBeanDefinition)bd);
                } else if (bd instanceof ChildBeanDefinition) {
                    RootBeanDefinition pbd;
                    ChildBeanDefinition cbd;
                    block13: {
                        cbd = (ChildBeanDefinition)bd;
                        pbd = null;
                        try {
                            if (!beanName.equals(cbd.getParentName())) {
                                pbd = this.getMergedBeanDefinition(cbd.getParentName(), true);
                                break block13;
                            }
                            if (this.getParentBeanFactory() instanceof AbstractBeanFactory) {
                                AbstractBeanFactory parentFactory = (AbstractBeanFactory)this.getParentBeanFactory();
                                pbd = parentFactory.getMergedBeanDefinition(cbd.getParentName(), true);
                                break block13;
                            }
                            throw new NoSuchBeanDefinitionException(cbd.getParentName(), "Parent name '" + cbd.getParentName() + "' is equal to bean name '" + beanName + "': cannot be resolved without an AbstractBeanFactory parent");
                        }
                        catch (NoSuchBeanDefinitionException ex) {
                            throw new BeanDefinitionStoreException(cbd.getResourceDescription(), beanName, "Could not resolve parent bean definition '" + cbd.getParentName() + "'", (Throwable)((Object)ex));
                        }
                    }
                    mbd = new RootBeanDefinition(pbd);
                    mbd.overrideFrom(cbd);
                } else {
                    throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName, "Definition is neither a RootBeanDefinition nor a ChildBeanDefinition");
                }
                if (this.isCacheBeanMetadata() && this.alreadyCreated.contains(beanName)) {
                    this.mergedBeanDefinitions.put(bd, mbd);
                }
            }
            return mbd;
        }
    }

    protected void checkMergedBeanDefinition(RootBeanDefinition mergedBeanDefinition, String beanName, Object[] args) throws BeansException {
        if (mergedBeanDefinition.isAbstract()) {
            throw new BeanIsAbstractException(beanName);
        }
        if (args != null) {
            if (mergedBeanDefinition.isSingleton()) {
                throw new BeanDefinitionStoreException("Cannot specify arguments in the getBean() method when referring to a singleton bean definition");
            }
            if (mergedBeanDefinition.getFactoryMethodName() == null) {
                throw new BeanDefinitionStoreException("Can only specify arguments in the getBean() method in conjunction with a factory method");
            }
        }
    }

    protected Class resolveBeanClass(RootBeanDefinition mbd, String beanName) {
        if (mbd.hasBeanClass()) {
            return mbd.getBeanClass();
        }
        try {
            return mbd.resolveBeanClass(this.getBeanClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "Bean class [" + mbd.getBeanClassName() + "] not found", (Throwable)ex);
        }
        catch (NoClassDefFoundError err) {
            throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "Class that bean class [" + mbd.getBeanClassName() + "] depends on not found", (Throwable)err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectForBeanInstance(Object beanInstance, String name, RootBeanDefinition mbd) throws BeansException {
        String beanName = this.transformedBeanName(name);
        if (BeanFactoryUtils.isFactoryDereference(name) && !(beanInstance instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, beanInstance.getClass());
        }
        boolean shared = mbd == null || mbd.isSingleton();
        Object object = beanInstance;
        if (beanInstance instanceof FactoryBean) {
            if (!BeanFactoryUtils.isFactoryDereference(name)) {
                FactoryBean factory = (FactoryBean)beanInstance;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Bean with name '" + beanName + "' is a factory bean"));
                }
                if (shared && factory.isSingleton()) {
                    Map map = this.factoryBeanObjectCache;
                    synchronized (map) {
                        object = this.factoryBeanObjectCache.get(beanName);
                        if (object == null) {
                            object = this.getObjectFromFactoryBean(factory, beanName, mbd);
                            this.factoryBeanObjectCache.put(beanName, object);
                        }
                    }
                } else {
                    object = this.getObjectFromFactoryBean(factory, beanName, mbd);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Calling code asked for FactoryBean instance for name '" + beanName + "'"));
            }
        }
        return object;
    }

    private Object getObjectFromFactoryBean(FactoryBean factory, String beanName, RootBeanDefinition mbd) throws BeanCreationException {
        Object object;
        try {
            object = factory.getObject();
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
        }
        if (mbd != null && !mbd.isSynthetic()) {
            object = this.postProcessObjectFromFactoryBean(object, beanName);
        }
        return object;
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) {
        return object;
    }

    public boolean isFactoryBean(String name) throws NoSuchBeanDefinitionException {
        String beanName = this.transformedBeanName(name);
        Object beanInstance = this.getSingleton(beanName);
        if (beanInstance != null) {
            return beanInstance instanceof FactoryBean;
        }
        if (!this.containsBeanDefinition(beanName) && this.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return ((AbstractBeanFactory)this.getParentBeanFactory()).isFactoryBean(name);
        }
        RootBeanDefinition bd = this.getMergedBeanDefinition(beanName, false);
        Class beanClass = this.resolveBeanClass(bd, beanName);
        return (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = AbstractBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).equals(beanClass);
    }

    protected boolean isBeanNameUsed(String beanName) {
        return this.containsLocalBean(beanName) || this.hasDependentBean(beanName);
    }

    protected void registerDisposableBeanIfNecessary(String beanName, Object bean, RootBeanDefinition mergedBeanDefinition) {
        if (mergedBeanDefinition.isSingleton() && (bean instanceof DisposableBean || mergedBeanDefinition.getDestroyMethodName() != null || this.hasDestructionAwareBeanPostProcessors())) {
            this.registerDisposableBean(beanName, new DisposableBeanAdapter(bean, beanName, mergedBeanDefinition, this.getBeanPostProcessors()));
            String[] dependsOn = mergedBeanDefinition.getDependsOn();
            if (dependsOn != null) {
                for (int i = 0; i < dependsOn.length; ++i) {
                    this.registerDependentBean(dependsOn[i], beanName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        Map map = this.factoryBeanObjectCache;
        synchronized (map) {
            this.factoryBeanObjectCache.remove(beanName);
        }
    }

    protected abstract boolean containsBeanDefinition(String var1);

    protected abstract BeanDefinition getBeanDefinition(String var1) throws BeansException;

    protected abstract Object createBean(String var1, RootBeanDefinition var2, Object[] var3) throws BeanCreationException;

    protected Class getTypeForFactoryMethod(String beanName, RootBeanDefinition mergedBeanDefinition) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

